#! /bin/sh
##  $Header: mkmailpost.sh,v 1.3 89/11/27 18:24:55 rsalz Exp $
##  Script to make a set of "mailpost" commands for all groups in
##  the news active file.
##  Usage:
##	makemailpost [news active file [mail2newspath] ]

case $# in
[012])
    ;;
*)
    echo "Usage: `basename $0` [activefile [mail2newspath] ]" 1>&2
    exit 1
    ;;
esac

ACTIVE=${1-/usr/lib/news/active}
if [ ! -f ${ACTIVE} ] ; then
    echo "`basename $0`:  Can't read input ${ACTIVE}." 1>&2
    exit 1
fi

##  Write the prolog.
echo "/*"
echo "**  Generated from ${ACTIVE}"
echo "**  by `whoami` on `date`"
echo "*/"
if [ "$2" != "" ] ; then
    echo 'default mail2news "'$2'";'
fi

trap "rm -f /tmp/mmp$$ ; exit 1" 1 2 3 15

##  Create the sed temporary file and run it
cat >/tmp/mmp$$ <<\EOF
# Delete moderated groups
/m$/d
# Trim anything after the first field
s/ .*$//
# Delete control, junk, site-specific
/^control$/d
/^junk$/d
/^to\./d
# Delete test groups and announce, assuming the latter is moderated
/\<test\>/d
/\<announce\>/d
# Turn the line "foo" into "mailpost foo;"
s/^.*$/mailpost &;/
EOF

##  Run sed, clean up.
sed -f /tmp/mmp$$ <${ACTIVE} | sort

rm -f /tmp/mmp$$
