%{
/*
**  GAG
**
**  Mail/news gateway alias generator.
*/
#define MAINLINE
#include "gate.h"
#ifdef	RCSID
static char RCS[] =
	"$Header: gag.y,v 1.4 90/03/12 10:34:26 rsalz Exp $";
#endif	/* RCSID */

#define EMPTY(p)		((p) == NULL || (p)[0] == '\0')

extern int	yylineno;
extern char	yytext[];
extern char	yyfilename[];
extern FILE	*yyin;

char		*Pname;			/* Program name			*/

STATIC int	Errors;			/* Did user screw up?		*/
STATIC int	NoGroupCheck;		/* Don't check if valid group?	*/
STATIC int	PostViaMail;		/* Make post-news-group alias?	*/
STATIC char	*OutDir;		/* Directory for MMDF scripts	*/
STATIC FILE	*mmdf;			/* File for MMDF aliases	*/
STATIC FILE	*sendmail;		/* File for Sendmail aliases	*/
STATIC FILE	*news;			/* File for sys file entries	*/

STATIC char	*CurDirectory,		*DefDirectory;
STATIC char	**CurDistribs,		**DefDistribs;
STATIC int	CurDoMailinglist,	DefDoMailinglist;
STATIC char	*CurFlags,		*DefFlags;
STATIC char	*CurMail2news,		*DefMail2news;
STATIC char	*CurMailcontact,	*DefMailcontact;
STATIC char	*CurMailhost,		*DefMailhost;
STATIC char	*CurModerator,		*DefModerator;
STATIC char	*CurNews2mail,		*DefNews2mail;
STATIC char	*CurOrganization,	*DefOrganization;
STATIC char	*CurOwner,		*DefOwner;
STATIC char	*CurRequestAddr,	*DefRequestAddr;
STATIC char	*CurSite,		*DefSite;
STATIC char	*CurUser,		*DefUser;

extern time_t	time();
%}

%union {
    char	*String;
    int		Bool;
}

%token	COMMAND DEFAULT DIRECTORY DISTRIBUTIONS DO DOTIFY FALSEt GATEWAY
%token	FLAGS ID INEWSt
%token	MAIL2NEWS MAILCONTACT MAILHOST MAILINGLIST MAILPOST MODERATOR
%token	NEWS2MAIL NO ORGANIZATION OWNER REQUESTADDR SITE TRUEt USER

%type	<String>	ID value
%type	<Bool>		boolean

%%

file	: /* NULL */
	| file block ';'
	| file default ';'
	| file mpost ';'
	| file error ';' {
#ifdef	lint
	    /* Compulsive... */
	    if (yylineno)
		YYERROR;
#endif	/* lint */
	}
	;

default	: DEFAULT DIRECTORY value	{ DefDirectory = $3; }
	| DEFAULT DISTRIBUTIONS value	{ (void)Split($3, &DefDistribs, '\0'); }
	| DEFAULT INEWSt FLAGS value	{ DefFlags = $4; }
	| DEFAULT MAIL2NEWS value	{ DefMail2news = $3; }
	| DEFAULT MAILCONTACT value	{ DefMailcontact = $3; }
	| DEFAULT MAILHOST value	{ DefMailhost = $3; }
	| DEFAULT MAILINGLIST boolean	{ DefDoMailinglist = $3; }
	| DEFAULT MODERATOR value	{ DefModerator = $3; }
	| DEFAULT NEWS2MAIL value	{ DefNews2mail = $3; }
	| DEFAULT ORGANIZATION value	{ DefOrganization = $3; }
	| DEFAULT OWNER value		{ DefOwner = $3; }
	| DEFAULT REQUESTADDR value	{ DefRequestAddr = $3; }
	| DEFAULT SITE value		{ DefSite = $3; }
	| DEFAULT USER value		{ DefUser = $3; }
	;

block	: op_init GATEWAY ID ID op_set {
	    if (!Errors && ValidNewsgroup($3))
		WriteOne($3, $4);
	}
	;

mpost	: op_init MAILPOST ID op_set {
	    char	*GroupasMail;

	    if (!Errors && ValidNewsgroup($3)) {
		GroupasMail = Dot2Dash($3);
		if (mmdf)
		    MMDFpostviamail($3, GroupasMail);
		if (sendmail)
		    Fprintf(sendmail, "%s: \"|%s -n %s\"\n",
			    GroupasMail, CurMail2news, $3);
	    }
	}
	;

op_init	: /* NULL */ {
	    CurDoMailinglist = DefDoMailinglist;
	    CurDistribs = DefDistribs;
	    CurDirectory = DefDirectory;
	    CurFlags = DefFlags;
	    CurMail2news = DefMail2news;
	    CurMailhost = DefMailhost;
	    CurMailcontact = DefMailcontact;
	    CurModerator = DefModerator;
	    CurNews2mail = DefNews2mail;
	    CurOrganization = DefOrganization;
	    CurOwner = DefOwner;
	    CurRequestAddr = DefRequestAddr;
	    CurSite = DefSite;
	    CurUser = DefUser;
	}
	;

op_set	: /* NULL */
	| an_opt op_set
	;

an_opt	: DIRECTORY value	{ CurDirectory = $2; }
	| DISTRIBUTIONS value	{ (void)Split($2, &CurDistribs, '\0'); }
	| INEWSt FLAGS value	{ CurFlags = $3; }
	| MAIL2NEWS value	{ CurMail2news = $2; }
	| MAILCONTACT value	{ CurMailcontact = $2; }
	| MAILHOST value	{ CurMailhost = $2; }
	| MAILINGLIST boolean	{ CurDoMailinglist = $2; }
	| MODERATOR value	{ CurModerator = $2; }
	| NEWS2MAIL value	{ CurNews2mail = $2; }
	| ORGANIZATION value	{ CurOrganization = $2; }
	| OWNER value		{ CurOwner = $2; }
	| REQUESTADDR value	{ CurRequestAddr = $2; }
	| SITE value		{ CurSite = $2; }
	| USER value		{ CurUser = $2; }
	;

value	: '=' ID {
	    $$ = $2;
	}
	| '=' DOTIFY '(' ID ')' {
	    $$ = Dotify($4);
	}
	;

boolean	: '=' TRUEt {
	    $$ = TRUE;
	}
	| '=' FALSEt {
	    $$ = FALSE;
	}
	;
%%


/*
**  Copy the string s turning all '.' into '-'.
*/
STATIC char *
Dot2Dash(s)
    register char	*s;
{
    register char	*p;
    char		*save;

    for (save = p = COPY(s); *s; s++)
	*p++ = *s == '.' ? '-' : *s;
    *p = '\0';
    return save;
}


/*
**  Copy the string s putting a '.' before all uppercase letters and '.'.
*/
STATIC char *
Dotify(s)
    register char	*s;
{
    register char	*p;
    char		*save;

    for (save = p = NEW(char, strlen(s) * 2 + 1); *s; *p++ = *s++)
	if (*s == '.' || isupper(*s))
	    *p++ = '.';
    *p = '\0';
    return save;
}


/*
**  Check if the newsgroup exists in the ACTIVE file.
*/
STATIC int
ValidNewsgroup(Group)
    register char	*Group;
{
    static char		**File;
    register char	**p;
    register char	*q;

    if (NoGroupCheck)
	return TRUE;

    if (File == NULL)
	/* Read in active file, trim to just the newsgroup names. */
	for (p = File = ReadFile(ACTIVE); *p; p++)
	    if (q = IDX(*p, ' '))
		*q = '\0';

    for (p = File; *p; p++)
	if (EQ(*p, Group))
	    return TRUE;

    Fprintf(stderr, "%s: ignoring invalid newsgroup \"%s\".\n", Pname, Group);
    return FALSE;
}


/*
**  Create an MMDF alias set so that users can mail into a newsgroup
**  as if it were a mailing list.
*/
STATIC void
MMDFpostviamail(Ngroup, GroupasMail)
    char		*Ngroup;
    char		*GroupasMail;
{
    register FILE	*F;
    char		buff[SM_SIZE];

    /* Create a post-news-group alias which pipes into
     * the /bin/dir/post-news-group script. */
    Fprintf(mmdf, "post-%s: @%s { \"%s|%s/post-%s\" }\n",
	    GroupasMail, CurMailhost, CurUser, CurDirectory,
	    GroupasMail);
    Fprintf(mmdf, "\tpost-%s@%s\n", GroupasMail, CurMailhost);

    /* Write a post-news-script which calls mail2news. */
    if (OutDir) {

	/* Open the file. */
	(void)sprintf(buff, "%s/post-%s", OutDir, GroupasMail);
	(void)unlink(buff);
	if ((F = fopen(buff, "w")) == NULL) {
	    Fprintf(stderr, "%s:  Can't open \"%s\" for output, %s.\n",
		    Pname, buff, Estring());
	    exit(1);
	}

	/* Write the script. */
	Fprintf(F, "#! /bin/sh\n");
	Fprintf(F, "## This script forwards into the \"%s\" newsgroup.\n",
		Ngroup);
	Fprintf(F, "exec %s -n %s\n", CurMail2news, Ngroup);

	/* Close the file. */
	(void)fclose(F);
	(void)chmod(buff, 0755);
    }
}


/*
**  Write out one newsgroup/mailing list gatewaying entry.  This is where
**  the real work is done.  We do MMDF, Sendmail, and news/sys file entries
**  here.
*/
STATIC void
WriteOne(Ngroup, Mlist)
    register char	*Ngroup;
    register char	*Mlist;
{
    register char	**p;
    register FILE	*F;
    register char	*GroupasMail;
    char		buff[SM_SIZE];

    GroupasMail = Dot2Dash(Ngroup);

    if (mmdf) {
	/* Create an alias that forwards to the script. */
	Fprintf(mmdf, "\n##  Add this to the \"%s\" mailing list.\n", Mlist);
	Fprintf(mmdf, "%s-gate: @%s { \"%s|%s/gate-%s\" }\n",
		Mlist, CurMailhost, CurUser, CurDirectory, Mlist);
	Fprintf(mmdf, "\t%s-gate@%s\n", Mlist, CurMailhost);

	/* Write the script. */
	if (OutDir) {
	    if (IDX(CurOrganization, '"')) {
		yyerror("Can't have \" in organization name");
		free(GroupasMail);
		return;
	    }

	    /* Open the file. */
	    (void)sprintf(buff, "%s/gate-%s", OutDir, Mlist);
	    (void)unlink(buff);
	    if ((F = fopen(buff, "w")) == NULL) {
		Fprintf(stderr, "%s:  Can't open \"%s\" for output, %s.\n",
			Pname, buff, Estring());
		exit(1);
	    }

	    /* Write it. */
	    Fprintf(F, "#! /bin/sh\n");
	    Fprintf(F, "## This script is on the \"%s\" mailing list.\n",
		    Mlist);
	    Fprintf(F, "exec %s -n %s", CurMail2news, Ngroup);
	    if (!EMPTY(CurOrganization))
		fprintf(F, "\\\n\t-o \"%s\"", CurOrganization);
	    if (!EMPTY(CurModerator))
		Fprintf(F, "\\\n\t-a %s", CurModerator);
	    if (!EMPTY(CurFlags))
		Fprintf(F, " \\\n\t%s", CurFlags);
	    Fprintf(F, "\n");

	    /* Close it. */
	    (void)fclose(F);
	    (void)chmod(buff, 0755);
	}

	if (PostViaMail)
	    MMDFpostviamail(Ngroup, GroupasMail);
    }

    if (sendmail) {
	if (IDX(CurOrganization, '\'')) {
	    yyerror("Can't have ' in organization name");
	    free(GroupasMail);
	    return;
	}

	/* Does it make sense to do this? */
	if (!EMPTY(CurModerator) && CurDoMailinglist)
	    Fprintf(stderr, "Warning:  group %s is moderated and mailable.\n",
		    Ngroup);

	Fprintf(sendmail, "\n## %s <==> %s gateway\n", Ngroup, Mlist);
	Fprintf(sendmail, "%s%s: %s@%s\n",
		CurDoMailinglist ? "" : "#", Mlist, Mlist, CurMailhost);
	if (!EMPTY(CurOwner))
	    Fprintf(sendmail, "%sowner-%s: %s\n",
		    CurDoMailinglist ? "" : "#", Mlist, CurOwner);
	Fprintf(sendmail, "post-%s: \"|%s -n %s", Mlist, CurMail2news, Ngroup);
	if (!EMPTY(CurOrganization))
	    Fprintf(sendmail, "-o '%s'", CurOrganization);
	if (!EMPTY(CurFlags))
	    Fprintf(sendmail, " %s", CurFlags);
	if (!EMPTY(CurModerator))
	    Fprintf(sendmail, " -a %s", CurModerator);
	Fprintf(sendmail, "\"\n");
	if (!EMPTY(CurOwner))
	    Fprintf(sendmail, "owner-post-%s: %s\n", Mlist, CurOwner);

	if (PostViaMail) {
	    Fprintf(sendmail, "%s: \"|%s -n %s\"\n",
		    GroupasMail, CurMail2news, Ngroup);
	    if (!EMPTY(CurOwner))
		Fprintf(sendmail, "owner-%s: %s\n", GroupasMail, CurOwner);
	}
    }

    if (news) {
	/* Sanity check. */
	if (CurSite == NULL) {
	    Fprintf(stderr, "Can't write sys files without a site!\n");
	    exit(1);
	}

	/* Psuedo-site name and distributions. */
	Fprintf(news, "%s\\\n  :", CurSite);
	for (p = CurDistribs; *p; p++)
	    Fprintf(news, "%s,!%s.all,", *p, *p);
	Fprintf(news, "%s,!%s.all\\\n ", Ngroup, Ngroup);

	/* Command invocation. */
	if (CurRequestAddr)
	    Fprintf(news, "  ::%s %s %s %s %s %%s\n",
		    CurNews2mail, Mlist, CurMailcontact, CurRequestAddr,
		    CurMailhost);
	else
	    Fprintf(news, "  ::%s %s %s %s-request %s %%s\n",
		    CurNews2mail, Mlist, CurMailcontact, CurMailcontact,
		    CurMailhost);
    }

    /* Clean up. */
    free(GroupasMail);
}



/*
**  Write an error message.
*/
yyerror(p)
    char	*p;
{
    char	buff[SM_SIZE];

    (void)strncpy(buff, yytext, sizeof buff);
    buff[sizeof buff - 1] = '\0';
    Fprintf(stderr, "\"%s\", line %d: %s (near \"%s\")\n",
	    yyfilename, yylineno, p, buff);
    Errors++;
}


/*
**  Open a file, or use - for standard output.
*/
STATIC FILE *
openfile(name)
    char	*name;
{
    FILE	*F;

    if (EQ(name, "-"))
	return stdout;
    if ((F = fopen(name, "w")) == NULL) {
	Fprintf(stderr, "%s:  Can't open \"%s\" for output, %s.\n",
		Pname, name, Estring());
	exit(1);
    }
    return F;
}


STATIC void
Usage()
{
    Fprintf(stderr, "Usage:\n\t%s %s input\n",
	    Pname,
	    "[-b] [-p] [-d dir] [-m mmdf] [-n news] [-s sendmail]");
    exit(1);
}


main(ac, av)
    int		ac;
    char	*av[];
{
    static char	PROLOG[] = "--START-OF-GATEWAY-OUTPUT-";
    static char	EPILOG[] = "--END-OF-GATEWAY-OUTPUT-";
    static char	LINE1[] =
	"This section of the alias file has been built automatically;";
    static char	LINE2[] =
	"if you make any changes here they will be lost when it is rebuilt.";
    int		c;
    time_t	now;
    char	*timestring;

    /* Set defaults. */
    Pname = (Pname = RDX(av[0], '/')) ? Pname + 1 : av[0];
    (void)umask(0);
    now = time((time_t *)NULL);
    timestring = ctime(&now);

    /* Parse JCL. */
    while ((c = getopt(ac, av, "bd:m:n:ps:")) != EOF)
	switch (c) {
	default:
	    Usage();
	    /* NOTREACHED */
	case 'b':
	    NoGroupCheck = TRUE;
	    break;
	case 'd':
	    OutDir = optarg;
	    break;
	case 'm':
	    mmdf = openfile(optarg);
	    break;
	case 'n':
	    news = openfile(optarg);
	    break;
	case 'p':
	    PostViaMail++;
	    break;
	case 's':
	    sendmail = openfile(optarg);
	    break;
	}

    /* Get input. */
    av += optind;
    if (*av == NULL)
	(void)strcpy(yyfilename, "stdin");
    else {
	if (av[1])
	    Usage();
	if ((yyin = fopen(*av, "r")) == NULL) {
	    Fprintf(stderr, "%s: Can't open \"%s\" for input, %s.\n",
		    Pname, *av, Estring());
	    exit(1);
	}
	(void)strcpy(yyfilename, *av);
    }

    /* Write prologs. */
    if (mmdf) {
	Fprintf(mmdf, "##  %s\n", PROLOG);
	Fprintf(mmdf, "##  Created at %s", timestring);
	Fprintf(mmdf, "##  %s\n", LINE1);
	Fprintf(mmdf, "##  %s\n", LINE2);
    }
    if (news) {
	Fprintf(news, "##  %s\n", PROLOG);
	Fprintf(news, "##  Created at %s", timestring);
    }
    if (sendmail) {
	Fprintf(sendmail, "##  %s\n", PROLOG);
	Fprintf(sendmail, "## Created at %s", timestring);
	Fprintf(sendmail, "##  %s\n", LINE1);
	Fprintf(sendmail, "##  %s\n", LINE2);
    }

    /* Do the work. */
    (void)yyparse();

    /* Close files. */
    if (mmdf) {
	Fprintf(mmdf, "##  %s\n", EPILOG);
	if (mmdf != stdout)
	    (void)fclose(mmdf);
    }
    if (news) {
	Fprintf(news, "##  %s\n", EPILOG);
	if (news != stdout)
	    (void)fclose(news);
    }
    if (sendmail) {
	Fprintf(sendmail, "##  %s\n", EPILOG);
	if (sendmail != stdout)
	    (void)fclose(sendmail);
    }

    /* That's all she wrote... */
    exit(Errors == 0 ? 0 : 1);
    /* NOTREACHED */
}
