/*
 * bcopy -- we use it instead of memcpy because behaviour is guaranteed not
 *		to surprise in case of overlapping memory blocks.
 */

#include "hostenv.h"
#ifndef	USE_BCOPY

void
bcopy(from, to, len)
	register char *from, *to;
	register int len;
{
#ifdef USE_MEMMOVE
	memmove(to, from, len);
#else
	while (--len >= 0)
		*to++ = *from++;
#endif
}

#endif	/* !USE_BCOPY */
