/*  This file should be edited with 4-column tabs! */
/*  Author: Mark Moraes <moraes@csri.toronto.edu> */

/*LINTLIBRARY*/

#include "defs.h"
#include "globals.h"

RCSID("$Header: /j/moraes/shmem/malloc/malloc/RCS/trace.c,v 1.7 89/10/31 02:02:13 moraes Exp $");

/*
 *  Turns tracing on (if value != 0) or off, (if value == 0)
 */
void
mal_trace(value)
int value;
{
	if (value) {
		/* Try to unbuffer the trace file */
		(void) setvbuf(_malloc_statsfile, (char *) 0, _IONBF, 0);
		/* 
		 *  Write something to the stats file so stdio can initialize
		 *  its buffers i.e. call malloc() at least once while tracing
		 *  is off, if the unbuffering failed.
		 */
		(void) fputs("Malloc tracing starting\n", _malloc_statsfile);
		(void) fflush(_malloc_statsfile);
		_malloc_tracing = 1;
	} else {
		/* For symmetry */
		(void) fputs("Malloc tracing stopped\n", _malloc_statsfile);
		_malloc_tracing = 0;
	}
}
