/*  This file should be edited with 4-column tabs! */
/*  Author: Mark Moraes <moraes@csri.toronto.edu> */

/*LINTLIBRARY*/

#include "defs.h"
#include "globals.h"

RCSID("$Header: /j/moraes/shmem/malloc/malloc/RCS/setsbrk.c,v 1.7 89/10/31 02:01:56 moraes Exp $");

/*
 *  Allows you to control the number of system calls made, which might
 *  be helpful in a program allocating a lot of memory - call this once
 *  to set a number big enough to contain all the allocations. Or for
 *  very little allocation, so that you don't get a huge space just
 *  because you alloc'e a couple of strings
 */
void
mal_sbrkset(n)
int n;
{
	if (n < _malloc_minchunk * sizeof(Word)) {
		/* sbrk'ing anything less than a Word isn't a great idea.*/
		return;
	}

	_malloc_sbrkunits = (n + sizeof(Word) - 1) / sizeof(Word);
	return;
}
