/*  This file should be edited with 4-column tabs! */
/*  Author: Mark Moraes <moraes@csri.toronto.edu> */

/*LINTLIBRARY*/

#include "defs.h"
#include "globals.h"
#include "trace.h"

RCSID("$Header: /j/moraes/shmem/malloc/malloc/RCS/_emalloc.c,v 1.8 89/10/31 02:09:45 moraes Exp $");

univptr_t
__emalloc(nbytes, fname, linenum)
size_t nbytes;
const char *fname;
int linenum;
{
	univptr_t cp;
	
	PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	cp = emalloc(nbytes);
	RECORD_FILE_AND_LINE(cp, fname, linenum);
	return(cp);
}


univptr_t
__erealloc(ptr, nbytes, fname, linenum)
univptr_t ptr;
size_t nbytes;
const char *fname;
int linenum;
{
	univptr_t cp;
	
	PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	cp = erealloc(ptr, nbytes);
	RECORD_FILE_AND_LINE(cp, fname, linenum);
	return(cp);
}
