/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include "libsupport.h"

struct address {
	struct address	*link;		/* next sender / sender for this rcpt */
	char		*channel;
	char		*host;
	char		*user;
	char		*misc;		/* expected to be uid privilege */
};

struct rcpt {
	struct rcpt	*next;
	struct address	*addr;		/* addr.link is the sender address */
	char		*newmsgheader;	/* message header pointer */
	long		id;		/* the index of this address */
	long		lockoffset;	/* the index of the address lock */
	int		status;		/* current delivery sysexit code */
	struct ctldesc	*desc;		/* backpointer to descriptor */
	/* XX: something needed for XOR address lists */
};

struct ctldesc {
	char		*msgfile;	/* message file name */
	char		*logident;	/* message id for logging */
	long		msgbodyoffset;	/* offset of message body in msgfile */
	int		msgfd;		/* message file I/O descriptor */
	int		ctlfd;		/* control file I/O descriptor */
	int		ctlid;		/* control file id (inode number) */
	char		*contents;	/* message file data */
	long		*offset;	/* array of indices into contents */
	struct address	*senders;	/* list of sender addresses */
	struct rcpt	*recipients;	/* list of selected recipients */
};

extern struct ctldesc *ctlopen();
extern void ctlclose();
extern int ctlsticky();

#ifdef STDARG_H
extern void diagnostic(struct rcpt *rp, ...);
#else
extern void diagnostic();
#endif
extern int getout;
extern SIGNAL_TYPE wantout();
