/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include "mailer.h"
#include <fcntl.h>
#include <signal.h>

/*
 * Reopen the log files, done at daemon startup, and when you want to roll over
 * the log files by doing a kill -HUP `cat .pid.router`.  The result of calling
 * this routine should be that stdout and stderr are attached to the same output
 * stream (for now anyway).
 * XX: possibly too much done inside a signal handler?
 */

int
loginit()
{
	extern char *log, *progname;
	int flags;

	if (log == NULL)
		return -1;
	(void) fflush(stdout);
	(void) rewind(stdout);
	(void) fflush(stderr);
	(void) rewind(stderr);
	if (freopen(log, "a+", stdout) != stdout
#ifdef	USE_DUP2
	    || dup2(fileno(stdout), fileno(stderr)) < 0) {	/* sigh */
#else	/* !USE_DUP2 */
	    || (close(fileno(stderr)), dup(fileno(stdout))) < 0) { /* sigh */
#endif	/* USE_DUP2 */
		/* XX: stderr might be closed at this point... */
		fprintf(stderr, "%s: cannot open log: %s\n", progname, log);
		return -1;
	}
#if	defined(F_SETFL) && defined(O_APPEND)
	flags = fcntl(fileno(stdout), F_GETFL, 0);
	flags |= O_APPEND;
	(void) fcntl(fileno(stdout), F_SETFL, flags);
#endif	/* F_SETFL */
	(void) setvbuf(stdout, (char *)NULL, _IOLBF, 0);
	(void) setvbuf(stderr, (char *)NULL, _IOLBF, 0);
	(void) signal(SIGHUP, loginit);
	return 0;
}
