/* --------------------
	vmail -- call.c

	Routines that call MH equivalents, editor, shell.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#include "defs.h"
#include <signal.h>

#define WARNING	"Warning -- mail headers may be out of date"

union wait status;

/* --------------------
	Fork a call to `comp'.
	Terminal type must be reset before call.
-------------------- */
void
comp()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], *next_token();
	int		i, (*oldint)(), (*oldquit)(), (*signal())();

	*s1 = '\0';
	if(comp_args) {
		sprintf(str, "(give options to)   comp ");
		get_string(str, s1);
	}
	clear();
	addstatus("composing mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		argv[0] = COMP;
		for(i=1, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execv(COMP, argv);
		printf("Warning: can't execute %s\n", COMP);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	wait(&status);
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}


/* --------------------
	Fork a call to `forw'.
	Terminal type must be reset before call.
-------------------- */
void
forw()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], s2[10], *next_token();
	int		i, (*oldint)(), (*oldquit)(), (*signal())();

	sprintf(s2, "%d", curmail->number);
	*s1 = '\0';
	if(forw_args) {
		sprintf(str, "(give options to)   forw +%s %s ", curflr->name, s2);
		get_string(str, s1);
	}
	clear();
	addstatus("forwarding mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		sprintf(str, "+%s", curflr->name);
		argv[0] = FORW; argv[1] = str; argv[2] = s2;
		for(i=3, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execv(FORW, argv);
		printf("Warning: can't execute %s\n", FORW);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	wait(&status);
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}


/* --------------------
	Fork a call to `repl'.
	Terminal type must be reset before call.
-------------------- */
void
repl()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], s2[10], *next_token();
	int		i, (*oldint)(), (*oldquit)(), (*signal())();

	sprintf(s2, "%d", curmail->number);
	*s1 = '\0';
	if(repl_args) {
		sprintf(str, "(give options to)   repl +%s %s ", curflr->name, s2);
		get_string(str, s1);
	}
	clear();
	addstatus("answering mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		sprintf(str, "+%s", curflr->name);
		argv[0] = REPL; argv[1] = str; argv[2] = s2;
		for(i=3, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execv(REPL, argv);
		printf("Warning: can't execute %s\n", REPL);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	wait(&status);
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}


/* --------------------
	Fork a call to editor.
	Terminal type must be reset before call.
-------------------- */
void
edit()
{
	char	str[LEN];
	int		(*oldint)(), (*oldquit)(), (*signal())();

	clear();
	mvaddstr(TITLE, 0, "editing mail ...");
	move(STATUS, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		no_control();
		sprintf(str, "%s/%s/%d", mail_dir, curflr->name, curmail->number);
		execlp(editor, editor, str, 0);
		printf("Warning: can't execute %s\n", editor);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	wait(&status);
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
}


/* --------------------
	Fork a call to shell.
	Terminal type must be reset before call.

	This should perhaps be modified so that only a single command can be
	issued, as in vi ... but this was simpler to do.
-------------------- */
void
call_shell()
{
	int		(*oldint)(), (*oldquit)(), (*signal())();

	clear();
	mvaddstr(TITLE, 0, "calling shell ...");
	move(STATUS, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		no_control();
		fix_mh();
		execlp(shell, shell, "-i", 0);
		printf("Warning: can't execute %s\n", shell);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	wait(&status);
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
}


/* --------------------
	Pipe current mail item into given command.
-------------------- */
void
do_pipe()
{
	char	str[LEN], s1[LEN];
	int		(*oldint)(), (*oldquit)(), (*signal())();

	*s1 = '\0';
	sprintf(str, "(give command to)   show +%s %d | ", curflr->name,
														curmail->number);
	get_string(str, s1);
	clear();
	addstatus("piping mail ...", false);
	move(STATUS+1, 0);
	refresh();
	sprintf(str, "%s %s/%s/%d | %s", CAT, mail_dir, curflr->name,
														curmail->number, s1);
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	no_control();
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	system(str);			/* exec needs full path of command => use system */
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
}
