/*-------------------------------------------------------------------------
 *  Listserv - Unix Mailing List manager (sub-set of FRECP's
 *             Bitnet Listserv tool.
 *
 *  Copyright (C) 1991,1992  Kimmo Suominen, Christophe Wolfhugel
 *
 *  Please read the files COPYRIGHT and AUTHORS for the extended
 *  copyrights refering to this file.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------*/

static char rcsid[] = "@(#)$Id: str.c,v 1.6 92/09/11 09:51:33 wolf Exp $";

/*
 * $Revision: 1.6 $
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "conf.h"

int strspacecmp(str1, str2)
char *str1, *str2;
{
   int c1, c2;

   while (1) {
      c1 = *str1++; 
      c2 = *str2++;
      if (isupper(c1)) c1 += 32;
      if (isupper(c2)) c2 += 32;
      if (c1==' ' || c1=='\t') c1=0;
      if (c2==' ' || c2=='\t') c2=0;
      if (c1 == c2) {
         if (c1==0)
            return(0);
         continue;
      } /* endif */
      if (c1 < c2)
         return -1;
      return 1;
   } /* endwhile */
}

#ifdef NEED_STRCASE

int strcasecmp(str1, str2)
char *str1, *str2;
{
   int c1, c2;

   while (1) {
      c1 = *str1++;
      c2 = *str2++;
      if (isupper(c1)) c1 += 32;
      if (isupper(c2)) c2 += 32;
      if (c1 == c2) {
         if (!c1)
            return(0);
         continue;
      } /* endif */
      if (c1 < c2)
         return -1;
      return 1;
   } /* endwhile */
}

int strncasecmp(str1, str2, n)
char *str1, *str2;
int n;
{
   int c1, c2;

   while (n--) {
      c1 = *str1++;
      c2 = *str2++;
      if (isupper(c1)) c1 += 32;
      if (isupper(c2)) c2 += 32;
      if (c1 == c2) {
         if (!c1)
            return(0);
         continue;
      } /* endif */
      if (c1 < c2)
         return -1;
      return 1;
   } /* endwhile */
   return(0);
}

#endif /* NEED_STRCASE */
