# ps2paper
#
# 25-Jun-92 weber@eitech.com updated for new parameter format
# 29-May-92 weber@eitech.com
#
# Copyright (c)  1992 Enterprise Integration Technologies Corporation
#
# Permission to use, copy, modify, distribute, and sell this software and 
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the name of
# Enterprise Integration Technologies Corporation may not be used in any 
# advertising or publicity relating to the software without the specific, 
# prior written permission of Enterprise Integration Technologies Corporation.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
#
# IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
# LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
# ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
# PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
# THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
# This service scans through a message body for postscript source, and
# sends what it found to the printer.  If the input is a multipart, it
# scans through the last body in the multipart.  It also does a check
# to see if the address is local (it won't print otherwise).
#
proc doprint {switches envelope inputs} {
    if {[local [getfield $envelope FROM]]} {
      if {[getfield $inputs TYPE] == "multipart"} {
	set parts [getfield $inputs PARTS]
	return [doprint $switches $envelope [lindex $parts [expr [llength $parts] - 1]]]
      } {
    	exec awk "/^%\\!/,/^%%EOF\$/" [getfield $inputs FILE] | lpr -Preal
	setfield response STRING "Postscript sent to printer."
	return [mailout [turnaround $envelope] $response]
      }
    } {
      setfield response STRING "Sorry, I can only print for locals."
      return [mailout [turnaround $envelope] $response]
    }
}
