NAME

listserv

SYNOPSIS

listserv [directive [mailinglist ...]]

DESCRIPTION

This service mimicks most of the commands in the listserv package for mailing
list maintenance.  The available directives are:

lists                                     get names of lists at this site
subscribe <mailing list> <your real name> get on a mailing list
unsubscribe <mailing list>                get off a mailing list
signoff <mailing list>                    ditto
recipients <mailing list>                 get list of mailing list members
review <mailing list>                     ditto
information <mailing list>                get a blurb on a mailing list
which                                     get a list of the mailing lists in
                                          which you appear
get archive <mailing list>                get the archive of
                                          mailing list submissions
release                                   get information on the release
help                                      get this message

If the incoming message has a Reply-to: header line, then that address
will be used for the (un)subscriptions, etc., as well as the
destination for all responses.  (Thus one can manipulate someone
else's memberships).

For added compatibility with the original LISTSERV package, if there
is no directive on the subject line then the body of the message will
be processed.  Each line is treated as a complete directive, with
blank lines being ignored and a line consisting entirely of two dashes
(--) ending processing.  Multiple responses will be delivered as
multiple messages.

Membership in mailing lists can be confidential (i.e., recipients and
review will not respond will a list of members) if the mailing list
file is made not readable by "other" on the local system.

The get command (via archive-request) looks in the archive directory for
a file by the same name as the <mailing list>.  Thus we suggest that an
entry in the mailing list be the name of this file (sendmail appends new
messages onto this file).

LIMITATIONS

Mailing lists must be manually created; e.g., to create a list called "mylist",
do a "touch ~/Lists/mylist" and then add the following line to your system's
/etc/aliases file: "mylist: :include:~/Lists/mylist" (where you have to replace
the "~" with services' home directory on your system).
