# archive-request
#
# 16-Sept-92 weber@eitech.com
#
# Copyright (c)  1992 Enterprise Integration Technologies Corporation
#
# Permission to use, copy, modify, distribute, and sell this software and 
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the name of
# Enterprise Integration Technologies Corporation may not be used in any 
# advertising or publicity relating to the software without the specific, 
# prior written permission of Enterprise Integration Technologies Corporation.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
#
# IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
# LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
# ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
# PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
# THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
# This service scans through a message body for postscript source, and
# sends what it found to the printer.  If the input is a multipart, it
# scans through the last body in the multipart.  It also does a check
# to see if the address is local (it won't print otherwise).
#
# This service retrieves a file from an anonymous ftp site.
#

proc ftp {switches envelope inputs} {
  set site [getfield $switches site]
# should this be the requestor instead of the services account?
  set user "[exec whoami]@[exec hostname]"
  set dir  [getfield $switches directory]
  set file [getfield $switches name]
  set mode [getfield $switches mode]
  puts stdout "$site $user $file"
  set fid [open "|ftp -n" w]
  puts $fid "open $site"
  puts $fid "user anonymous $user"
  if {$dir != ""} {puts $fid "cd $dir"}
  if {$mode != ""} {puts $fid "type $mode"}
  puts $fid "get $file $file"
  puts $fid "quit"
  if {[catch "close $fid" ftpout] || ![file exists $file]} {
    setfield response STRING "Sorry, ftp didn't work.\n$ftpout"
    setfield response DESCRIPTION "error return from anon-ftp"
  } {
    setfield response FILE $file
    setfield response DESCRIPTION "the file you requested of anon-ftp"
    setmimetype response
  }
  return [mailout [turnaround $envelope] $response]
}

proc setmimetype {objectname} {
    # set up filename as call-by-name
    upvar $objectname object
    set filename [getfield $object FILE]
    case $filename {
	*.ps { setfield object TYPE application; setfield object SUBTYPE postscript }
	*.tex { setfield object TYPE text; setfield object SUBTYPE x-latex }
	*.c { setfield object TYPE application; setfield object SUBTYPE x-c }
	*.sh { setfield object TYPE application; setfield object SUBTYPE x-sh }
	*.tar.Z { setfield object TYPE application
		  setfield object SUBTYPE octet-stream
		  setfield params name $filename
		  setfield params type tar
		  setfield params conversions compress
		  setfield object PARAMS $params
		}
	*.tar { setfield object TYPE application
		  setfield object SUBTYPE octet-stream
		  setfield params name $filename
		  setfield params type tar
		  setfield object PARAMS $params
		}
    }
}
