/*
** Get header info from mail-format file.
** Return non-zero on success.
*/
/* Lifted from  sendmail ? */


#include <ctype.h>
#include <sys/types.h>
#include <stdio.h>
#include "llist.h"

#define TRUE 1
#define FALSE 0

#define LBUFLEN 256
#define BUFLEN 512

char   *arpadate();
char   *errmsg();
char   *strpbrk();
time_t cgtdate();
extern char    *index();
extern unsigned        strlen();
extern time_t  time();

/*
** strip leading and trailing spaces
*/
char *
sp_strip(s)
register char  *s;
{
       register char   *cp;

       if (s == NULL)
               return(NULL);

       if (*s == '\0')
               return(s);

       cp = &s[strlen(s) - 1];
       while(cp > s && isspace(*cp))
               cp--;

       *++cp = '\0';   /* zap trailing spaces */

       for(cp = s; *cp && isspace(*cp); cp++)
               continue;

       return(cp);     /* return pointer to first non-space */
}

/*
** crack an RFC822 from header field into address and fullname.
*/

/* addr[PATHLEN], name[LBUFLEN] */
int
crackfrom(addr,name,field)
char   *addr, *name, *field;
{
       char    commbuf[LBUFLEN];
       char    addrbuf[LBUFLEN];
       register char   *p;
       register char   *ap = addrbuf;
       register char   *np;
       short   commfound = 0, comment = 0;
       short   addrfound = 0, address = 0;
       ll_t    comm, *cp = &comm;

       *name = '\0';   /* just make sure */
       *addr = '\0';

       if ((p = field) == NULL)
               return(FALSE);

       while(*p && isspace(*p))        /* eat leading white space */
               p++;

       while(*p) {
               switch(*p) {
               case '(':
                       if (comment == 0) {
                               np = commbuf;
                               *np = '\0';
                       }
                       comment++;
                       break;
               case ')':
                       if (comment > 0 && --comment == 0) {
                               *np++ = *p++;   /* note incr; skip `)' */
                               *np++ = '\0';
                               if ((cp = l_alloc(cp, commbuf, strlen(commbuf) +
 1)) == NULL) {
                                       if (commfound)
                                               l_free(comm);
                                       return(FALSE);
                               }
                               commfound++;
                               np = NULL;
                               continue;
                       }
                       break;
               case '<':
                       if (address) {
                               if (commfound)
                                       l_free(comm);
                               return(FALSE);  /* AWK! Abort! */
                       }
                       if (!comment) {
                               address++;
                               *ap = '\0';
                               ap = addr;
                       }
                       break;
               case '>':
                       if (!comment && address) {
                               address--;
                               addrfound++;
                               *ap = '\0';
                               ap = &addrbuf[strlen(addrbuf)];
                               p++;    /* skip the `>' */
                       }
                       break;
               }

               if (comment) {
                       *np++ = *p;
               } else if (address) {
                       if (*p != '<')
                               *ap++ = *p;
               } else {
                       *ap++ = *p;
               }
               if (*p)
                       p++;
               else
                       break;
       }

       *ap++ = '\0';

       if (addrfound) {
               (void) strcpy(name, sp_strip(addrbuf));
               (void) strcpy(addr, strcpy(commbuf, sp_strip(addr)));
       } else {
               (void) strcpy(addr, sp_strip(addrbuf));
               *name = '\0';
       }
       /*
       ** Just to be sure that we got the full name,
       ** we'll take all of the comments!
       */
       if (commfound) {
               register int    len;
               register int    flag = (*name != '\0' ? TRUE : FALSE);

               L_LOOP(cp, comm) {
                       if (flag)
                               (void)strcat(name, ", ");
                       flag = TRUE;
                       if (cp->l_item[cp->l_len - 2] == ')')
                               cp->l_item[cp->l_len - 2] = '\0';
                       (void)strcat(name, sp_strip(&cp->l_item[1]));
               }
               l_free(comm);
       }
       return(TRUE);
}

#ifdef notdef  /* nobody obeys the triply damned protocol anyway! */
/*
** Special characters, see RFC822, appendix D.
*/
isspecial(c)
char   c;
{
       char    *specials = "()<>@,;:\\\".[]";

       if (index(specials, c) != (char *)NULL)
               return(TRUE);
       return(FALSE);
}

/*
** Check on the validity of an RFC822 message-id
**
** By The Book, RFC822 Appendix D.
**     msg-id          = "<" addr-spec ">"
**     addr-spec       = local-part "@" domain
**     local-part      = word *("." word)
**     word            = atom / quoted-string
**     domain          = sub-domain *("." sub-domain)
**     sub-domain      = domain-ref / domain-literal
**     domain-ref      = atom
**     domain-literal  = "[" *(dtext / quoted-pair) "]"
**
** NOTE: close reading of the RFC822 spec indicates that a fully
**     qualified domain name (i.e. one with at least one dot) is
**     NOT required in the domain part of the addr-spec. However,
**     I've decided to be an asshole and require them, since we'll
**     all die a slow death later on if I don't at this juncture.
**     To disable, if you disagree with me, see the last return
**     statement. - Erik E. Fair <fair@ucbarpa.berkeley.edu>
**     May 30, 1986
*/
msgid_ok(id)
register char  *id;
{
       register Langle = FALSE;
       register Rangle = FALSE;
       register local_part = FALSE;
       register at = FALSE;
       register dot = FALSE;

       /* skip up to the opening angle bracket */
       if (id == (char *)NULL || (id = index(id, '<')) == (char *)NULL)
               return(FALSE);          /* don't waste my time! */

       for(; *id != '\0'; id++) {
               switch(*id) {
               case '<':
                       if (Langle) return(FALSE);
                       Langle = local_part = TRUE;
                       break;
               case '>':
                       if (Rangle || !Langle || !at) return(FALSE);
                       else Rangle = TRUE;
                       break;
               case '@':               /* should be a domain spec */
                       at = TRUE;
                       local_part = FALSE;
                       break;
               case '.':
                       dot = at;
                       break;
               case '\\':
                       /*
                       ** quoted pair; this disallows NULs, but how
                       ** many mailers would die if someone used one?
                       */
                       if (!local_part || (*++id) == '\0') return(FALSE);
                       break;
               case '"':
                       /*
                       ** quoted string
                       */
                       if (!local_part) return(FALSE);
                       do {
                               switch(*++id) {
                               case '\\':
                                       if ((*++id) == '\0') return(FALSE);
                                       break;
                               case '\r':
                                       return(FALSE);
                               }
                       } while(*id != '\0' && *id != '"');
                       break;
               case '[':
                       /*
                       ** domain literal
                       */
                       if (local_part) return(FALSE);
                       do {
                               switch(*++id) {
                               case '\\':
                                       if ((*++id) == '\0') return(FALSE);
                                       break;
                               case '\r':
                                       return(FALSE);
                               }
                       } while(*id != '\0' && *id != ']');
                       break;
               default:
                       if (!isascii(*id) || iscntrl(*id) || isspace(*id) || iss
pecial(*id))
                               return(FALSE);  /* quit immediately */
                       break;
               }
       }
       return(at && dot && Langle && Rangle);
}
#else /*notdef*/
/*
** Simpleton's check for message ID syntax.
** A concession to the realities of the ARPA Internet.
*/
msgid_ok(s)
register char *s;
{
       register char   c;
       register in_msgid = FALSE;

       if (s == (char *)NULL)
               return(FALSE);

       while((c = *s++) != '\0') {
               if (!isascii(c) || iscntrl(c) || isspace(c))
                       return(FALSE);
               switch(c) {
               case '<':
                       in_msgid = TRUE;
                       break;
               case '>':
                       return(in_msgid);
               }
       }
       return(FALSE);
}
#endif /*notdef*/

/*
 * arpadate is like ctime(3) except that the time is returned in
 * an acceptable ARPANET time format instead of ctime format.
 */
char *
arpadate(longtime)
time_t *longtime;
{
       register char *p, *q, *ud;
       register int i;
       static char b[40];
       extern struct tm *gmtime();
       extern char *asctime();

       /*  Get current time. This will be used resolve the timezone. */
       ud = asctime(gmtime(longtime));

       /*  Crack the UNIX date line in a singularly unoriginal way. */
       q = b;

#ifdef notdef
/* until every site installs the fix to getdate.y, the day
   of the week can cause time warps */
       p = &ud[0];             /* Mon */
       *q++ = *p++;
       *q++ = *p++;
       *q++ = *p++;
       *q++ = ','; *q++ = ' ';
#endif

       p = &ud[8];             /* 16 */
       if (*p == ' ')
               p++;
       else
               *q++ = *p++;
       *q++ = *p++; *q++ = ' ';

       p = &ud[4];             /* Sep */
       *q++ = *p++; *q++ = *p++; *q++ = *p++; *q++ = ' ';

       p = &ud[22];            /* 1979 */
       *q++ = *p++; *q++ = *p++; *q++ = ' ';

       p = &ud[11];            /* 01:03:52 */
       for (i = 8; i > 0; i--)
               *q++ = *p++;

       *q++ = ' ';
       *q++ = 'G';             /* GMT */
       *q++ = 'M';
       *q++ = 'T';
       *q = '\0';

       return b;
}

#if 0
time_t
cgtdate(datestr)
char *datestr;
{
       char    junk[40], month[40], day[30], tod[60], year[50], buf[BUFLEN];
       static time_t   lasttime;
       static char     lastdatestr[BUFLEN] = "";
       extern time_t   getdate();

       if (lastdatestr[0] && strcmp(datestr, lastdatestr) == 0)
               return(lasttime);
       lasttime = getdate(datestr, (struct timeb *)NULL);
       if (lasttime < 0 &&
         sscanf(datestr, "%s %s %s %s %s", junk, month, day, tod, year) == 5) {
               (void) sprintf(buf, "%s %s, %s %s", month, day, year, tod);
               lasttime = getdate(buf, (struct timeb *)NULL);
       }
       strncpy(lastdatestr, datestr, BUFLEN);
       return(lasttime);
}
#endif

char *
errmsg(code)
int code;
{
       extern int sys_nerr;
       extern char *sys_errlist[];
       static char ebuf[6+5+1];

       if (code > sys_nerr) {
               (void) sprintf(ebuf, "Error %d", code);
               return ebuf;
       } else
               return sys_errlist[code];
}

/*
 * Strip trailing newlines, blanks, and tabs from 's'.
 * Return TRUE if newline was found, else FALSE.
 */
nstrip(s)
register char *s;
{
       register char *p;
       register int rc;

       rc = FALSE;
       p = s;
       while (*p)
               if (*p++ == '\n')
                       rc = TRUE;
       while (--p >= s && (*p == '\n' || *p == ' ' || *p == '\t'));
       *++p = '\0';
       return rc;
}

prefix(full, pref)
register char *full, *pref;
{
       register char fc, pc;

       while ((pc = *pref++) != '\0') {
               fc = *full++;
               if (isupper(fc))
                       fc = tolower(fc);
               if (isupper(pc))
                       pc = tolower(pc);
               if (fc != pc)
                       return FALSE;
       }
       return TRUE;
}

#ifndef USG
char *
strpbrk(str, chars)
register char *str, *chars;
{
       register char *cp;

       do {
               cp = chars - 1;
               while (*++cp) {
                       if (*str == *cp)
                               return str;
               }
       } while (*str++);
       return NULL;
}
#endif /* !USG */
