/* ****************************************************************
 *
 *  CMDLIB.C	Collection of usefull utilities used all over
 *		mailserver code..
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *
 * **************************************************************** */


#include <sys/param.h>
#include <stdio.h>
#ifndef BSD
#include <ctype.h>
#endif
#include "input.h"

extern char *malloc();
extern char *strchr(), *strrchr();


#ifdef	L_xsalloc
char *
xsalloc(str)
char *str;
{
	int len = strlen(str);
	char *s = malloc(len+2);

	if (!s) {
	  fprintf(stderr,"MALLOC FAILURE!\n");
	  fflush(stderr);
	  abort(7);
	}
	strcpy(s,str);
	return s;
}
#endif

#ifdef	L_xrealloc
void *
xrealloc(ptr,size)
void *ptr;
unsigned size;
{
	void *p = (void*) realloc(ptr,size);
	if (!p) {
	  fprintf(stderr,"REALLOC FAILURE!\n");
	  fflush(stderr);
	  abort(8);
	}
	return p;
}
#endif

#ifdef	L_xcalloc
void *
xcalloc(size)
unsigned size;
{
	void *p = (void*) malloc(size);
	if (!p) {
	  fprintf(stderr,"CALLOC FAILURE!\n");
	  fflush(stderr);
	  abort(9);
	}
	memset(p,0,size);
	return p;
}
#endif

#ifdef	L_upperstr
char *
upperstr(str)
char *str;
{
	register char *s = str;

	if (str == NULL) return str;
	while (*s) {
	  if (islower(*s))
	    *s = toupper(*s);
	  ++s;
	}
	return str;
}
#endif

#ifdef	L_lowerstr
char *
lowerstr(str)
char *str;
{
	register char *s = str;

	if (str == NULL) return str;
	while (*s) {
	  if (isupper(*s))
	    *s = tolower(*s);
	  ++s;
	}
	return str;
}
#endif


#ifdef	L_rdomaincmp
int
revdomaincmp(s1,s2)
char *s1,*s2;
{
	char *d1, *d2, *od1, *od2;
	int rc;

	d1 = strrchr(s1,'.');	/* Find last `.' */
	d2 = strrchr(s2,'.');
	while (d1 && d2) {
	  rc = strcasecmp(d1,d2);
	  if (rc != 0) return rc;
	  od1 = d1; od2 = d2;
	  *od1 = 0; *od2 = 0;	/* hide previously last `.' */
	  d1 = strrchr(s1,'.');	/* Find last `.' */
	  d2 = strrchr(s2,'.');
	  *od1 = '.'; *od2 = '.'; /* reinstall previous `.' */
	}
	return strcasecmp(s1,s2);
}
#endif


#ifdef	L_pick_narg
/* ****************************************************************
 *
 *  pick_nextarg()  scan over 1st token, once past it, skip spaces/tabs
 *		    (mark EOL (NULL) on first space) and return pointer
 *		    to begining of next token.
 *		    Return NULL if no next token(s)..
 *
 * **************************************************************** */

char *
pick_nextarg(argstr)
char *argstr;
{
	register char *s = argstr;

	if (!s || *s == 0) return NULL;

	/* If space or tab, skip it */
	while (*s == ' ' || *s == '\t') ++s;

	/* Scan over token, until next space/tab */
	while (*s && *s != ' ' && *s != '\t') ++s;
	if (*s) { /* Space or tab */
	  *s++ = 0;
	  while (*s == ' ' || *s == '\t') ++s;
	}
	if (*s)
	  return s;
	return NULL;
}
#endif

#ifdef	L_strerror
/* ****************************************************************
 *
 * strerror() -- similar is in BSD 4.3/4.4, but this is independently
 *		 implemented for this package (not so big thing...)
 *
 * **************************************************************** */

char *
strerror(errno)
int errno;
{
	extern int sys_nerr;
	extern char *sys_errlist[];
	static char errmsg[40];

	if (errno < 0 || errno > sys_nerr) {
	  sprintf(errmsg,"Unknown error nro: %d",errno);
	  return errmsg;
	}
	return sys_errlist[errno];
}
#endif

#ifdef	L_strsignal
/* ****************************************************************
 *
 *	strsignal(signalnro)
 *	strerrno(errno)
 *
 *   Return a string to signal name - without SIG prefix
 *
 * **************************************************************** */

static char *signalnames[] = {
	"0",				/* 0	No signal	*/
	"HUP",				/* 1	HUP		*/
	"INT",				/* 2	INT		*/
	"QUIT",				/* 3	QUIT		*/
	"ILL",				/* 4	ILL		*/
	"TRAP",				/* 5	trace trap	*/
	"ABRT",				/* 6	abort (generated by abort(3) routine) */
	"EMT",				/* 7	emulator trap */
	"FPE",				/* 8	 arithmetic exception */
	"KILL",				/* 9	kill (cannot be caught, blocked, or ignored) */
	"BUS",				/* 10	bus error */
	"SEGV",				/* 11	segmentation violation */
	"SYS",				/* 12	bad argument to system call */
	"PIPE",				/* 13	write on a pipe or other socket with no one to read it */
	"ALRM",				/* 14	alarm clock */
	"TERM",				/* 15	software termination signal */
	"URG",				/* 16	urgent condition present on socket */
	"STOP",				/* 17	stop (cannot be caught, blocked, or ignored) */
	"TSTP",				/* 18	stop signal generated from keyboard */
	"CONT",				/* 19	continue after stop */
	"CHLD",				/* 20	child status has changed */
	"TTIN",				/* 21	background read attempted from control terminal */
	"TTOU",				/* 22	background write attempted to control terminal */
	"IO",				/* 23	I/O is possible on a descriptor (see fcntl(2V)) */
	"XCPU",				/* 24	cpu time limit exceeded (see getrlimit(2)) */
	"XFSZ",				/* 25	file size limit exceeded (see getrlimit(2)) */
	"VTALRM",			/* 26	virtual time alarm (see getitimer(2)) */
	"PROF",				/* 27	profiling timer alarm (see getitimer(2)) */
	"WINCH",			/* 28	window changed (see termio(4) and win(4S)) */
	"LOST",				/* 29	resource lost (see lockd(8C)) */
	"USR1",				/* 30	user-defined signal 1 */
	"USR2"				/* 31	user-defined signal 2 */
};

char *
strsignal(signro)
int signro;
{
	if (signro < 1 || signro > 31)
		return "Unknown";

	return signalnames[signro];
}
#endif

#ifdef L_strncasecmp
int
strncasecmp(s1, s2, n)
    const char *s1, *s2;
    register int n;
{
    while(*s1 != '\0' && *s2 != '\0' && n > 0) {
    	if((*s1 & ~0x20) != (*s2 & ~0x20))
	    break;
	s1++; s2++; --n;
    }
    return((*s1&~0x20) == (*s2&~0x20) ? 0 : (*s1&~0x20) < (*s2&~0x20) ? -1 : 1);
}
#endif

#ifdef L_strcasecmp
int
strcasecmp(s1, s2)
    const char *s1, *s2;
{
    while(*s1 != '\0' && *s2 != '\0') {
    	if((*s1 & ~0x20) != (*s2 & ~0x20))
	    break;
	s1++; s2++;
    }
    return((*s1&~0x20) == (*s2&~0x20) ? 0 : (*s1&~0x20) < (*s2&~0x20) ? -1 : 1);
}
#endif

#ifdef	L_basename
char *
basename(filename)
    const char *filename;
{
    const char *s = strrchr(filename,'/');
    if (s) return ++s;
    return filename;
}
#endif
