# pr_doindex.pl -- execute index requests
# SCCS Status     : @(#)@ pr_doindex.pl	3.4
# Author          : Johan Vromans
# Created On      : Thu Jun  4 22:15:51 1992
# Last Modified By: Johan Vromans
# Last Modified On: Wed Dec 23 22:06:54 1992
# Update Count    : 6
# Status          : OK

sub index_loop {

    local ($entries) = 0;
    local ($name, $size, $date);
    local ($tally);
    local ($list_type) = "Index";
    local ($limit);

    print STDOUT ("Index results:\n");

    foreach $query ( @indexq ) {

	$~ = "list_header";
	write;
	$~ = "list_format";
	$: = " /";		# break filenames at logical places
	$= = 99999;
	$tally = 0;
	$limit = $maxindexlines > 0 ? $maxindexlines : 65535;

	if ( $indexfile =~ m|^/| ) {
	    if ( -r "$indexfile" ) {
		print STDOUT ("Index $query in $indexfile...\n")
		    if $opt_debug;
		$ENV{"LOCATE_DB"} = $indexfile;		# GNU find 3.6
		$ENV{"LOCATE_PATH"} = $indexfile;	# GNU find 3.7
		open ( IX, "$ixlookup '$query' |");
		while ( <IX> ) {
		    ($name, $size, $date) = /^(.+)\?(\d+)\?(\d+)$/;
		    $date =~ s|^(..)(..)(..)|1900+$1."/$2/$3"|e;
		    $size .= "K";
		    write;
		    last if ++$tally >= $limit;
		}
		close (IX);
	    }
	}
	else {
	    foreach $lib ( @libdirs ) {
		next unless -r "$lib/$indexfile" || $tally > $limit;
		print STDOUT ("Index $query in $lib/$indexfile...\n")
		    if $opt_debug;
		$ENV{"LOCATE_DB"} = "$lib/$indexfile";		# GNU find 3.6
		$ENV{"LOCATE_PATH"} = "$lib/$indexfile";	# GNU find 3.7

		open ( IX, "$ixlookup '$query' |");
		while ( <IX> ) {
		    ($name, $size, $date) = /^(.+)\?(\d+)\?(\d+)$/;
		    $date =~ s|^(..)(..)(..)|1900+$1."/$2/$3"|e;
		    $size .= "K";
		    write;
		    last if ++$tally >= $limit;
		}
		close (IX);
	    }
	}
	if ( $tally == 0 ) {
	    $name = "***not found***";
	    write;
	}
	elsif ( $tally >= $limit ) {
	    print STDOUT ("*** Too much output, remaining lines flushed ***\n");
	    # Lower the limit, but avoid zero value.
	    $maxindexlines = int ($maxindexlines / 2) + 1;
	}
    }
    @indexq = ();
    print STDOUT ("\n");
}

1;
