#!/usr/local/bin/perl
# chkconfig.pl -- check mserv configuration
# SCCS Status     : @(#)@ chkconfig	1.32
# Author          : Johan Vromans
# Created On      : Mon Apr 27 21:47:41 1992
# Last Modified By: Johan Vromans
# Last Modified On: Sat Jan  2 14:21:33 1993
# Update Count    : 146
# Status          : Development

# DISCLAIMER: This prograim aids in finding configuration values
# and potential problems. No guarantees, however.

$my_name = "chkconfig";
$my_version = "1.32";
#
################ Common stuff ################

$libdir = $ENV{"MSERVLIB"} || "/usr/local/lib/mserv";
unshift (@INC, $libdir);
&options if @ARGV > 0 && $ARGV[0] =~ /^-+[^-]+/;
@ARGV = ("-") unless @ARGV > 0;
if ( $opt_current) {
    chop ($libdir = `pwd`);
    $INC[0] = $libdir;
}
require "ms_common.pl";
require "patchlevel.h";

print ($my_package, " [", $my_name, " ", $my_version, "]\n");

################ Main ################

# Verify version.
local ($version) = $my_package =~ /([XYV]\d+\.\d+[A-Z]*)$/;

if ( $ms_version ne $version ) {
    print ("FATAL: Version mismatch\n",
	   '  patchlevel.h ', $ms_version, ' <-> ',
	   $version, ' ms_common.pl', "\n");
    die ("Aborted.\n");
}
       
print ("MSERVLIB = ", $ENV{"MSERVLIB"} || "(not set, but that's OK)", "\n");
print ("Program library: ", $libdir, " ", &fstat($libdir,1,1), "\n");
print ("\n");

if ( defined $mserv_owner && $mserv_owner ) {
    if ( @u = getpwnam ($mserv_owner) ) {
	print ("Server owner: ", $mserv_owner, ", uid = $u[2], gid = $u[3]",
	       ", \"", $u[6], "\"\n");
    }
    else {
	print ("Server owner: ", $mserv_owner, " *** Unknown ***\n");
    }
}
else {
    die ("\$mserv_owner is not defined!\n");
}
if ( defined $mserv_bcc && $mserv_bcc ) {
    if ( @u = getpwnam ($mserv_bcc) ) {
	print ("Bcc user: ", $mserv_bcc, ", uid = $u[2], gid = $u[3]",
	       ", \"", $u[6], "\"\n");
    }
    else {
	print ("Bcc user: ", $mserv_bcc, " *** Unknown ***\n");
    }
}
print ("\n");

if ( $have_setruid ) {
    print ("The 'listener' program will use the setruid system call\n");
    print ("  It will change identity to compiled-in uid $u[2]\n")
	if $use_uid;
    print ("  (setenv will be used to set USER, LOGNAME and HOME)\n")
	if $have_setenv;
    if ( -x "$libdir/listener" ) {
	@st = stat (_);
	unless ( $st[4] == $u[2] && $st[2] & 0004000 == 0004000 ) {
	    print ("The 'listener' program is not installed correctly!\n",
		   "  It should be installed setuid $mserv_owner\n");
	}
    }
    else {
	print ("The 'listener' program is not yet installed.\n",
	       "  Do not forget to install it setuid $mserv_owner\n");
    }
}
else {
    print ("The 'listener' program will use 'su' to change identity\n");
    if ( -x "$libdir/listener" ) {
	@st = stat (_);
	unless ( $st[4] == 0 && $st[2] & 0004000 == 0004000 ) {
	    print ("The 'listener' program is not installed correctly!\n",
		   "  It should be installed setuid root\n");
	}
    }
    else {
	print ("The 'listener' program is not yet installed\n",
	       "  Do not forget to install it setuid root\n");
    }
}
print "\n";

$f = $sendmail;
$f = $` if $f =~ / /;
print ("Replies will be sent using \"$sendmail\" ", &fstat($f,0,1), "\n");
print ("Preset mail headers:\n");
print (defined $sender ? "  $sender\n" : "  *** sender not defined ***\n");
print ("  ", join ("\n  ", @x_headers), "\n") if defined @x_headers;
print ("\n");

if ( defined @black_list ) {
    print ("Mail messages from the following users will be ",
	   $black_list_warning ?
	   "flagged with\na warning that they will be rejected in the future:" 
	   : "rejected:",
	   "\n");
    select (STDOUT);
    $~ = multi_line;
    $multi = join (' ', @black_list);
    $= = 999;
    write;
    print ("\n");
}

print ("Transfer strategies:\n");
if ( defined $email ) {
    $f = $chunkmail;
    $f = $` if $f =~ / /;
    print ("  email: \"$chunkmail\" ", &fstat($f,0,1), "\n");
    print ("         wait ", $mailer_delay, " seconds between chunks\n")
	if defined $mailer_delay;
    print ("         limits: ", $email_limits[1], "K (default), ",
	   $email_limits[0], "K (min), ", $email_limits[2], "K (max)\n");
}
if ( defined $uucp ) {
    $f = $uucp;
    $f = $` if $f =~ / /;
    print ("  uucp : \"$uucp\" ", &fstat($f,0,1), "\n");
    $f = $uuname;
    $f = $` if $f =~ / /;
    print ("         check host names using \"$uuname\" ", &fstat($f,0,1), "\n")
	if $uuname ne "";
    print ("         limits: ", $uucp_limits[1], "K (default), ",
	   $uucp_limits[0], "K (min), ", $uucp_limits[2], "K (max)\n");
    print ("         uucp transfer is preferred, if possible\n")
	if $prefer_uucp;
}
unless ( defined $email || defined $uucp ) {
    print ("  None. *** ARE YOU SURE? ***\n");
}
print ("\n");

print ("Search strategies:");
print (" File") if $dofilesearch;
print (" Directory") if $dodirsearch;
print (" Index") if $doindexsearch;
print ("\n");
print ("\n");

if ( ! ($dofilesearch || $dodirsearch || $doindexsearch) ) {
    print ("*** No search strategy defined ***\n\n");
}

print ("Archives:\n");
foreach $lib ( @libdirs ) {
    print ("  ", $lib, " ", &fstat($lib,1,1), "\n");
}
if ( defined $indexfile && defined $indexlib ) {
    print ("Archive for Index:\n");
    print ("  ", $indexlib, " ", &fstat($indexlib,1,1), "\n");
}
print ("\n");

if ( $doindexsearch && !( defined $indexfile ) ) {
    print ("*** No value for `indexfile' ***\n\n");
}

if ( $doindexsearch && defined $indexfile ) {
    print ("Indexfiles:\n");
    if ( $indexfile =~ m|^/| ) {
	print ("  ", $indexfile, " ", &fstat($indexfile), "\n");
	print ("  Archive for this index: ", $indexlib, "\n")
	    if defined $indexlib;
    }
    else {
	foreach $lib ( @libdirs ) {
	    local ($indexfile) = $lib . "/" . $indexfile;
	    print ("  ", $indexfile, " ", &fstat($indexfile), "\n");
	}
    }
    print ("Limit per index request: ", $maxindexlines, " lines.\n")
	if $maxindexlines > 0;
    print ("\n");
    print ("Index tools:\n");
    print ("  gfind      ", $gfind, " ", &fstat($gfind,0,1), "\n");
    print ("  ixlookup   ", $ixlookup, " ", &fstat($ixlookup,0,1), "\n");
    print ("  locatelib  ", $locatelib, " ", &fstat($locatelib,1,1), "\n");
    print ("\n");
}

print ("Server files:\n");
print ("  queue      ", $queue, " ", &fstat($queue), "\n");
print ("  logfile    ", $logfile, " ", &fstat($logfile), "\n");
print ("  lockfile   ", $lockfile, " ", &fstat($lockfile), "\n");
print ("  notes      ", $notesfile, " ", &fstat($notesfile), "\n");
print ("  hints      ", $hintsfile, " ", &fstat($hintsfile), "\n");
print ("\n");

# Locking
if ( defined $lock_fcntl ) {
    print ("Locking with fcntl(2).\n");
}
if ( defined $lock_flock ) {
    print ("Locking with flock(2).\n");
}
if ( defined $lock_lockf ) {
    print ("Locking with syscall(2)/lockf(2).\n");
}
if ( defined $lock_fcntl + defined $lock_flock + defined $lock_lockf > 1 ) {
    print ("*** Select one lock method.\n");
}
if ( defined $lock_fcntl + defined $lock_flock + defined $lock_lockf == 0 ) {
    print ("No locking selected. Proceed at your own risk\n");
}
else {
    # Just a quick test to see if things fit.
    local ($lf) = "/usr/tmp/fl$$";
    open (LF, ">$lf");
    eval { &locking (*LF, 0); };
    print "$@" if "$@";
    close (LF);
    unlink ($lf);
    print ("Use the 'testlock' program to verify the locking! (See INSTALL)\n");
}
print ("\n");

%enctab = ("B", "btoa", "U", "uuencode", "X", "xxencode", "D", "uue");

print ("Default encoding is ", $default_encoding, 
       " (", $enctab{$default_encoding}, ")\n");
print ("Encoders:\n");
foreach $f ( "btoa", "uuencode", "uue", "xxencode" ) {
    $exec = eval("\$$f");
    printf ("  %-10s %s %s\n", $f, $exec, 
	    &fstat($exec,0,
		   $f eq "uuencode" || $f eq $enctab{$default_encoding}),
	    "\n");
}
print ("\n");

print ("Tools:\n");
$f = $dircmd;
$f = $` if $f =~ / /;
print ("  dir: \"$dircmd\" ", &fstat($f, 0, 1), "\n");
if ( $archie ) {
    $f = $archie;
    $f = $` if $f =~ / /;
    print ("  archie: \"$archie\" ", &fstat($f, 0, 1), "\n");
}
if ( $cmd_extend ) {
    print ("  extensions: $cmd_extend ",
	   &fstat ($cmd_extend,0,1), "\n");
}

print ("  feedback limit = ", $fb_limit, "K\n") if $fb_limit;
print ("\n");

if ( $auto_compress ) {
    print ("Support for auto-compression is included.\n");
    print ("  Known extensions are tried BEFORE '.Z'.\n")
	if $auto_compress > 1;
    print ("  Compress using \"$compress\" ", &fstat($compress,0,1), "\n");
    print ("\n");
}

if ( defined $ftp && $ftp ) {
    print ("Support for FTP is included.\n");
    print ("  Limited to uucp only.\n") if $ftp_uucp_only;
    print ("  Cache dir = ", $ftp_cache, " ",
	   &fstat ($ftp_cache,1,1), "\n") if $ftp_cache;
    print ("  Files are kept for ", $ftp_keep, " days in the cache.\n")
	if $ftp_keep;
    require "$libdir/pr_ftp.pl";
    require "$libdir/dateconv.pl";
}
print ("\n");

if ( defined $packing_limit ) {
    print ("Support for packing is included.\n",
	   "  Packing limit = $packing_limit blocks.\n",
	   "  Dusk usage obtained using \"$du\" ", &fstat($du,0,1), "\n",
	   "  File list obtained using \"$find\" ", &fstat($find,0,1), "\n",
	   "  Methods:");
    if ( defined $pdtar ) {
	print (" tar ", &fstat($pdtar,0,1));
    }
    else {
	print (" tar ", &fstat($tar,0,1));
    }
    print (" zip ", &fstat($zip,0,1));
    print (" zoo ", &fstat($zoo,0,1));
    print ("\n");
    if ( defined $pdtar ) {
	print ("  Compress/Tar using \"$pdtar\" ", &fstat($pdtar,0,1), "\n");
    }
    else {
	print ("  Compress/Tar using \"$tar\" ", &fstat($tar,0,1), " and ",
	       "\"$compress\" ", &fstat($compress,0,1), "\n");
    }
    print ("  Automatic packing of directories is allowed.\n")
	if $auto_packing;
    print ("\n");
}
else {
    print ("Packing functionality not selected.\n\n");
}
print ("Working storage: $tmpdir ", &fstat($tmpdir,1,1), "\n\n");
print ("The queue will ", $auto_runrequest ? "automatically" : "not",
       " be run upon completion of process.\n");
if ( $nice ) {
    eval {
	if ( setpriority (0, $$, $nice ) ) {
	    print ("The mail server will be niced with $nice.\n");
	}
	else {
	    print ("Cannot set nice value $nice: $!\n");
	}
    };

    if ( $@ ) {
	print ("Cannot set nice value $nice: $@\n");
    }
}
print ("\n");

################ Subroutines ################

sub fstat {
    local ($file, $dir, $mustexist) = @_;
    return "[*** Not found ***]" if ! -e $file && $mustexist;
    return "[Not found, but that's OK]" unless -e _;
    return "[*** Not a directory ***]" if $dir && ! -d _;
    "[OK]";
}

sub options {
    require "newgetopt.pl";
    $opt_ident = $opt_help = 0;
    if ( !&NGetOpt ("config=s", "current", "ident", "help")
	|| $opt_help
	|| (@ARGV > 0)) {
	&usage;
    }
    $config_file = $opt_config if defined $opt_config;
}

sub usage {
    require "ms_common.pl";
    print STDERR <<EndOfUsage;
$my_package [$my_name $my_version]

Usage: $my_name [-options]

Options:
    -config XX	use alternate config
    -current	use current directory instead of $libdir
    -help	this message
    -ident	print identification
EndOfUsage
    exit (1);
}

format multi_line =
~~^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$multi
.
