/****************************************************************
 *	Copyright 1986, Gene H. Olson, Quest Research, Burnsville   *
 *	Minnesota.   Permission to copy and distribute this         *
 *	program, all associated code in source and binary form,     *
 *	for any purpose, so long as this notice is preserved.       *
 ****************************************************************/

/***************************************************************
 *         Program to print out DIALINFO entries               *
 ***************************************************************/

#include <stdio.h>

#include "readinfo.h"
#include "dialinfo.h"


/******
 *	dialprint - Print dialer info.
 */

dialprint(dinfo, dialer)
register DINFO *dinfo ;					/* Entry to print */
char *dialer ;							/* Dialer name */
{
	register char **cpp ;
	register int i ;
	
	(void) printf("%s,\n", dialer) ;

	if (dinfo->di_star) (void) printf("\tstar=%s,\n", dinfo->di_star) ;

	if (dinfo->di_pound) (void) printf("\tpound=%s,\n", dinfo->di_pound) ;

	if (dinfo->di_delay) (void) printf("\tdelay=%s,\n", dinfo->di_delay) ;

	if (dinfo->di_wait) (void) printf("\twait=%s,\n", dinfo->di_wait) ;

	if (dinfo->di_flash) (void) printf("\tflash=%s,\n", dinfo->di_flash) ;

	if (dinfo->di_retry >= 0) (void) printf("\tretry=%d,\n", dinfo->di_retry) ;

	i = 0 ;
	cpp = &dinfo->di_state[0] ;

	while (i < NSTATE) {
		if (*cpp) (void) printf("\ts%d=%s,\n", i, *cpp) ;
		i++ ;
		cpp++ ;
		}
	}



main(argc,argv)
int argc ;							/* Argument count */
char **argv ;						/* Argument vector */
{
	DINFO dinfo ;

	if (argc != 2) {
		(void) fprintf(stderr, "Bad arg count\n") ;
		return(2) ;
		}

	(void) dialinfo(&dinfo, argv[1]) ;

	dialprint(&dinfo, argv[1]) ;

	dialfree(&dinfo) ;

	return(0) ;
	}
