
/*
 * m_draft.c -- construct the name of a draft message
 *
 * $Id$
 */

#include <h/mh.h>
#include <errno.h>

extern int errno;


char *
m_draft (char *folder, char *msg, int use, int *isdf)
{
    register char *cp;
    register struct msgs *mp;
    struct stat st;
    static char buffer[BUFSIZ];

    if (*isdf == NOTOK || folder == NULL || *folder == 0) {
	if (*isdf == NOTOK || (cp = context_find ("Draft-Folder")) == NULL) {
	    *isdf = 0;
	    return m_maildir (msg && *msg ? msg : draft);
	}
	else
	    folder = path (*cp == '+' || *cp == '@' ? cp + 1 : cp,
		    *cp != '@' ? TFOLDER : TSUBCWF);
    }
    *isdf = 1;
    
    chdir (m_maildir (""));
    strcpy (buffer, m_maildir (folder));
    if (stat (buffer, &st) == NOTOK) {
	if (errno != ENOENT)
	    adios (buffer, "error on folder");
	cp = concat ("Create folder \"", buffer, "\"? ", NULL);
	if (!getanswer (cp))
	    done (0);
	free (cp);
	if (!makedir (buffer))
	    adios (NULL, "unable to create folder %s", buffer);
    }

    if (chdir (buffer) == NOTOK)
	adios (buffer, "unable to change directory to");

    if (!(mp = folder_read (folder)))
	adios (NULL, "unable to read folder %s", folder);

    /*
     * Make sure we have enough message space for the "new"
     * sequence.  If not, then add space for 100 messages.
     */
    if ((mp->hghmsg >= mp->hghoff) &&
	!(mp = folder_realloc (mp, 0, mp->hghmsg + 100)))
	adios (NULL, "unable to allocate folder storage");

    mp->msgflags |= MHPATH;

    /*
     * If we have been give a valid message name, then use that.
     * Else, if we are given the "use" option, then use the
     * current message.  Else, use special sequence "new".
     */
    if (!m_convert (mp, msg && *msg ? msg : use ? "cur" : "new"))
	done (1);
    seq_setprev (mp);

    if (mp->numsel > 1)
	adios (NULL, "only one message draft at a time!");

    sprintf (buffer, "%s/%s", mp->foldpath, m_name (mp->lowsel));
    cp = buffer;

    seq_setcur (mp, mp->lowsel);/* set current message for folder */
    seq_save (mp);		/* synchronize message sequences  */
    folder_free (mp);		/* free folder/message structure  */

    return cp;
}
