
/*
 * seq_setprev.c -- set the Previous-Sequence
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * Add all the messages currently SELECTED to
 * the Previous-Sequence.  This way, when the next
 * command is given, there is a convenient way to
 * selected all the messages used in the previous
 * command.
 */

void
seq_setprev (struct msgs *mp)
{
    register char *cp, *dp, **ap;

    dp = NULL;
    if ((cp = m_find (psequence)) == NULL
	    || (ap = brkstring (dp = getcpy (cp), " ", "\n")) == NULL
	    || *ap == NULL) {
	if (dp)
	    free (dp);
	return;
    }

    /* Now add all SELECTED messages to each sequence */
    for (; *ap; ap++)
	seq_addsel (mp, *ap, -1, 1);

    if (dp)
	free (dp);
}
