.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH REPL %manext1% MH.6.8 [%nmhversion%]
.SH NAME
repl \- reply to a message
.SH SYNOPSIS
.in +.5i
.ti -.5i
repl
\%[+folder] \%[msg]
\%[\-annotate] \%[\-noannotate]
.br
\%[\-cc\ all/to/cc/me] \%[\-nocc\ all/to/cc/me]
.br
\%[\-draftfolder\ +folder] \%[\-draftmessage\ msg]
.br
\%[\-nodraftfolder]
\%[\-editor\ editor] \%[\-noedit]
.br
\%[\-fcc\ +folder]
\%[\-filter\ filterfile]
\%[\-form\ formfile]
.br
.\" \%[\-format] \%[\-noformat]
\%[\-inplace] \%[\-noinplace]
\%[\-mime]
\%[\-nomime]
.br
\%[\-query] \%[\-noquery]
\%[\-width\ columns]
.br
\%[\-whatnowproc\ program] \%[\-nowhatnowproc]
.br
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIRepl\fR aids a user in producing a reply to an existing message.
\fIRepl\fR uses a reply template to guide its actions when constructing
the message draft of the reply.  In its simplest form (with no
arguments), it will set up a message\-form skeleton in reply to the
current message in the current folder, and invoke the whatnow shell.
The default reply template will direct \fIrepl\fR to construct the
composed message as follows:

.nf
.in 1i
To: <Reply\-To> or <From>
cc: <cc>, <To>, and yourself
Subject: Re: <Subject>
In\-reply\-to: Your message of <Date>.
.ti +\w'In\-reply\-to: 'u
<Message\-Id>
.in .5i
.fi

where field names enclosed in angle brackets (<\ >) indicate the contents
of the named field from the message to which the reply is being made.
A reply template is simply a format file.  See \fImh\-format\fR\0(5)
for the details.

The `\-cc\ type' switch takes an argument which specifies who gets
placed on the \*(lqcc:\*(rq list of the reply.  The `\-query' switch
modifies the action of `\-cc\ type' switch by interactively asking you
if each address that normally would be placed in the \*(lqTo:\*(rq and
\*(lqcc:\*(rq list should actually be sent a copy.  (This is useful for
special\-purpose replies.)  Note that the position of the `\-cc' and
`\-nocc' switches, like all other switches which take a positive and
negative form, is important.

.\" --this seems to not be used anymore. /JLR
.\" With the `\-format' switch one can indicate if Internet\-style
.\" formatting should be used (or not be used with `\-noformat').
.\" If present (the default), then 
Lines beginning with the fields \*(lqTo:\*(rq, \*(lqcc:\*(rq, and
\*(rqBcc:\*(rq will be standardized and have duplicate addresses removed.
In addition, the `\-width\ columns' switch will guide \fIrepl\fR's
formatting of these fields.

If the file named \*(lqreplcomps\*(rq exists in the user's nmh directory,
it will be used instead of the default form.  In either case, the file
specified by `\-form\ formfile' will be used if given.

If the draft already exists, \fIrepl\fR will ask you as to the disposition
of the draft.  A reply of \fBquit\fR will abort \fIrepl\fR, leaving the
draft intact; \fBreplace\fR will replace the existing draft with a blank
skeleton; and \fBlist\fR will display the draft.

See \fIcomp\fR\0(1) for a description of the `\-editor' and `\-noedit'
switches.  Note that while in the editor, the message being replied
to is available through a link named \*(lq@\*(rq (assuming the default
\fIwhatnowproc\fR\0).  In addition, the actual pathname of the message is
stored in the envariable \fB$editalt\fR, and the pathname of the folder
containing the message is stored in the envariable \fB$mhfolder\fR.

Although \fIrepl\fR uses the `\-form\ formfile' switch to direct it
how to construct the beginning of the draft, the `\-filter\ filterfile'
switch directs \fIrepl\fR as to how the message being replied\-to should
be formatted in the body of the draft.  If `\-filter' is not specified,
then the message being replied\-to is not included in the body of the
draft.  If `\-filter\ filterfile' is specified, then the message being
replied\-to is filtered (re\-formatted) prior to being output to the body
of the draft.  The filter file for \fIrepl\fR should be a standard form
file for \fImhl\fR, as \fIrepl\fR will invoke \fImhl\fR to format the
message being replied\-to.  There is no default message filter (`\-filter'
must be followed by a file name).  A filter file that is commonly used is:

.nf
.in +.5i
:
body:nocomponent,compwidth=9,offset=9
.in -.5i
.fi

which says to output a blank line and then the body of the message
being replied\-to, indented by one tab\-stop.  Another format popular
on USENET is:

.nf
.in +.5i
.ie n \{
message-id:nocomponent,\|nonewline,\\
formatfield=\*(lqIn message %{text},\ \*(rq \}
.el message-id:nocomponent,\|nonewline,\|formatfield=\*(lqIn message %{text},\ \*(rq
from:nocomponent,\|formatfield=\*(lq%(friendly{text}) writes:\*(rq
body:component=\*(lq>\*(rq,\|overflowtext=\*(lq>\*(rq,\|overflowoffset=0
.in -.5i
.fi

Which cites the Message-ID and author of the message being replied\-to,
and then outputs each line of the body prefaced with the \*(lq>\*(rq
character.

To use the MIME rules for encapsulation,
specify the `\-mime' switch.
This directs \fIreply\fR to generate an \fImhn\fR composition file.
Note that nmh will not invoke \fImhn\fR automatically,
unless you  add this line to your \&.mh\(ruprofile file:
.sp
.in +.5i
automhnproc: mhn
.in -.5i
.sp
Otherwise,
you must specifically give the command
.sp
.in +.5i
What now? edit mhn
.in -.5i
.sp
prior to sending the draft.

If you don't want to use this feature,
the manual page for \fIforw\fR contains another idea on how you can
automate this somewhat.

If the `\-annotate' switch is given, the message being replied\-to will
be annotated with the lines

     Replied:\ date
     Replied:\ addrs

where the address list contains one line for each addressee.
The annotation will be done only if the message is sent directly from
\fIrepl\fR.  If the message is not sent immediately from \fIrepl\fR,
\*(lqcomp\ \-use\*(rq may be used to re\-edit and send the constructed
message, but the annotations won't take place.  The `\-inplace' switch
causes annotation to be done in place in order to preserve links to the
annotated message.

The `\-fcc\ +folder' switch can be used to automatically specify a folder
to receive Fcc:s.  More than one folder, each preceeded by `\-fcc' can
be named.

In addition to the standard \fImh\-format\fR\0(5) escapes, \fIrepl\fR
also recognizes the following additional \fIcomponent\fR escape:
.sp 1
.nf
.ta \w'Escape  'u +\w'Returns  'u
\fIEscape\fR	\fIReturns\fR	\fIDescription\fR
\fIfcc\fR	string	Any folders specified with `\-fcc\ folder'
.re
.fi

To avoid reiteration, \fIrepl\fR strips any leading `Re: ' strings from
the \fIsubject\fR component.

The `\-draftfolder\ +folder' and `\-draftmessage\ msg' switches invoke
the \fInmh\fR draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the \fBAdvanced Features\fR section of the
\fInmh\fR manual for more information.

Upon exiting from the editor, \fIrepl\fR will invoke the \fIwhatnow\fR
program.  See \fIwhatnow\fR\0(1) for a discussion of available
options.  The invocation of this program can be inhibited by using the
`\-nowhatnowproc' switch.  (In truth of fact, it is the \fIwhatnow\fR
program which starts the initial edit.  Hence, `\-nowhatnowproc' will
prevent any edit from occurring.)

.Fi
^%etcdir%/replcomps~^The reply template
^or <mh\-dir>/replcomps~^Rather than the standard template
^$HOME/\&.mh\(ruprofile~^The user profile
^<mh\-dir>/draft~^The draft file
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Alternate\-Mailboxes:~^To determine the user's mailboxes
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^Draft\-Folder:~^To find the default draft\-folder
.Ps
^Editor:~^To override the default editor
.Ps
^Msg\-Protect:~^To set mode when creating a new message (draft)
.Ps
^fileproc:~^Program to refile the message
.Ps
^mhlproc:~^Program to filter message being replied\-to
.Ps
^whatnowproc:~^Program to ask the \*(lqWhat now?\*(rq questions
.Sa
comp(1), dist(1), forw(1), send(1), whatnow(1), mh\-format(5)
.De
`+folder' defaults to the current folder
.Ds
`msg' defaults to cur
.Ds
`\-nocc\ all' at ATHENA sites, `\-cc\ all' otherwise
.Ds
`\-noannotate'
.Ds
`\-nodraftfolder'
.Ds
`\-noinplace'
.Ds
`\-nomime'
.Ds
`\-noquery'
.Ds
`\-width\ 72'
.Co
If a folder is given, it will become the current folder.  The message
replied\-to will become the current message.
.Hi
Prior to using the format string mechanism, `\-noformat' used to cause
address headers to be output as\-is.  Now all address fields are formatted
using Internet standard guidelines.
.Bu
If any addresses occur in the reply template, addresses in the template
that do not contain hosts are defaulted incorrectly.  Instead of using
the localhost for the default, \fIrepl\fR uses the sender's host.
Moral of the story: if you're going to include addresses in a reply
template, include the host portion of the address.

The `\-width columns' switch is only used to do address-folding; other
headers are not line\-wrapped.

If \fIwhatnowproc\fR is \fIwhatnow\fR, then \fIrepl\fR uses a built\-in
\fIwhatnow\fR, it does not actually run the \fIwhatnow\fR program.
Hence, if you define your own \fIwhatnowproc\fR, don't call it
\fIwhatnow\fR since \fIrepl\fR won't run it.

If your current working directory is not writable, the link named
\*(lq@\*(rq is not available.
.En
