
/*
 * rmm.c -- remove a message(s)
 *
 * $Id$
 */

#include <h/mh.h>

static struct swit switches[] = {
#define VERSIONSW   0
    { "version", 0 },
#define	HELPSW      1
    { "help", 4 },
    { NULL, 0 }
};


main (int argc, char **argv)
{
    int msgp = 0, msgnum, vecp;
    char *cp, *dp, *maildir, *folder = NULL;
    char buf[100], **ap, **argp, **vec;
    char *arguments[MAXARGS], *msgs[MAXARGS];
    struct msgs *mp;

#ifdef LOCALE
    setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while ((cp = *argp++)) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown\n", cp);

		case HELPSW: 
		    sprintf (buf, "%s [+folder] [msgs] [switches]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULL, "only one folder at a time!");
	    else
		folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    msgs[msgp++] = cp;
    }

    if (!m_find ("path"))
	free (path ("./", TFOLDER));
    if (!msgp)
	msgs[msgp++] = "cur";
    if (!folder)
	folder = m_getfolder ();
    maildir = m_maildir (folder);

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to");

    /* read folder and create message structure */
    if (!(mp = m_gmsg (folder)))
	adios (NULL, "unable to read folder %s", folder);

    if (mp->hghmsg == 0)
	adios (NULL, "no messages in %s", folder);

    /* parse all the message ranges/sequences and set SELECTED */
    for (msgnum = 0; msgnum < msgp; msgnum++)
	if (!m_convert (mp, msgs[msgnum]))
	    done (1);
    m_setseq (mp);	/* set the previous-sequence */

    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++) {
	if (is_selected (mp, msgnum)) {
#ifdef notdef
	    mp->msgstats[msgnum] |= DELETED;
#endif	/* notdef */
	    mp->msgstats[msgnum] &= ~EXISTS;
	}
    }
    mp->msgflags |= SEQMOD;

    m_replace (pfolder, folder);	/* update current folder   */
    m_sync (mp);
    m_update ();			/* update the context file */

    if (rmmproc) {
	if (mp->numsel > MAXARGS - 2)
	    adios (NULL, "more than %d messages for %s exec", MAXARGS - 2,
		    rmmproc);
	vec = (char **) calloc ((size_t) (mp->numsel + 2), sizeof *vec);
	if (vec == NULL)
	    adios (NULL, "unable to allocate exec vector");
	vecp = 1;
	for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
	    if (is_selected (mp, msgnum))
		vec[vecp++] = getcpy (m_name (msgnum));
	vec[vecp] = NULL;

	fflush (stdout);
	vec[0] = r1bindex (rmmproc, '/');
	execvp (rmmproc, vec);
	adios (rmmproc, "unable to exec");
    }

    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++) {
	if (is_selected (mp, msgnum)) {
	    strcpy (buf, m_backup (dp = m_name (msgnum)));
	    if (rename (dp, buf) == NOTOK)
		admonish (buf, "unable to rename %s to", dp);
	}
    }

    m_fmsg (mp);		/* free folder/message structure */
    done (0);
}
