
/*
 * m_replace.c -- replace an entry in the profile
 *
 * $Id$
 */

#include <h/mh.h>


void
m_replace (char *key, char *value)
{
    register struct node *np;

    m_getdefs ();
    if (!m_defs) {
	np = m_defs = (struct node *) malloc (sizeof(*np));
	if (!np)
	    adios (NULL, "unable to allocate profile storage");

	np->n_name = getcpy (key);
	np->n_field = getcpy (value);
	np->n_context = 1;
	np->n_next = NULL;
	ctxflags |= CTXMOD;
	return;
    }

    for (np = m_defs;; np = np->n_next) {
	if (uleq (np->n_name, key)) {
	    if (strcmp (value, np->n_field)) {
		if (!np->n_context)
		    admonish (NULL, "bug: m_replace(key=\"%s\",value=\"%s\")", key, value);
		if (np->n_field)
		    free (np->n_field);
		np->n_field = getcpy (value);
		ctxflags |= CTXMOD;
	    }
	    return;
	}
	if (!np->n_next)
	    break;
    }
    np->n_next = (struct node *) malloc (sizeof(*np));
    if (!np->n_next)
	adios (NULL, "unable to allocate profile storage");

    np = np->n_next;
    np->n_name = getcpy (key);
    np->n_field = getcpy (value);
    np->n_context = 1;
    np->n_next = NULL;
    ctxflags |= CTXMOD;
}
