
/*
 * makedir.c -- make a directory
 *
 * $Id$
 */

/* Modified to try recursive create.  Really, this should be broken
 * out into a subr so that SYS5 systems can do this too.  I don't 
 * have a SYS5 machine around to test anymore, so someone else will
 * have to send me the code.
 */

#include <h/mh.h>

#if defined (BSD42) || defined (hpux) || defined(SVR4) || \
	defined(ncr) || defined (_AIX) || defined(AUX)
# include <errno.h>
# include <sys/param.h>
# include <sys/file.h>
#endif /* BSD42 ... */

extern int errno;
	
int
makedir (char *dir)
{
    pid_t pid;
    register char *cp;
    register char *c;
    char path[PATH_MAX];

    m_update();
    fflush(stdout);

    if (getuid () == geteuid ()) {
	    c = strcpy(path, dir);     

	    while ((c = strchr((c + 1), '/')) != NULL) {	
		    *c = (char)0;
		    if (access(path, X_OK)) {
			    if (errno != ENOENT){
				    advise (dir, "unable to create directory");
				    return 0;
			    }			    
			    if (mkdir(path, 0775)) {
				    advise (dir, "unable to create directory");
				    return 0;
			    }
		    }
		    *c = '/';
	    }
 
	    if (mkdir (dir, 0755) == NOTOK) {
		    advise (dir, "unable to create directory");
		    return 0;
	    }
    }
    else

    switch (pid = vfork()) {
	case NOTOK: 
	    advise ("fork", "unable to");
	    return 0;

	case OK: 
	    setgid (getgid ());
	    setuid (getuid ());

	    execl ("/bin/mkdir", "mkdir", dir, NULL);
	    execl ("/usr/bin/mkdir", "mkdir", dir, NULL);
	    fprintf (stderr, "unable to exec ");
	    perror ("mkdir");
	    _exit (-1);

	default: 
	    if (pidXwait(pid, "mkdir"))
		return 0;
	    break;
    }

    if ((cp = m_find ("folder-protect")) == NULL)
	cp = foldprot;
    chmod (dir, atooi (cp));
    return 1;
}

