
/*
 * scan.c -- display a one-line "scan" listing
 *
 * $Id$
 */

#include <h/mh.h>
#include <h/formatsbr.h>
#include <h/scansbr.h>
#include <zotnet/tws/tws.h>
#include <errno.h>

static struct swit switches[] = {
#define	CLRSW	0
    { "clear", 0 },
#define	NCLRSW	1
    { "noclear", 0 },
#define	FORMSW	2
    { "form formatfile", 0 },
#define	FMTSW	3
    { "format string", 5 },
#define	HEADSW	4
    { "header", 0 },
#define	NHEADSW	5
    { "noheader", 0 },
#define	WIDSW	6
    { "width columns", 0 },
#define	REVSW	7
    { "reverse", 0 },
#define	NREVSW	8
    { "noreverse", 0 },
#define	FILESW	9
    { "file file", 4 },
#define VERSIONSW 10
    { "version", 0 },
#define	HELPSW	11
    { "help", 4 },
    { NULL, 0 }
};

extern int errno;

/*
 * global for sbr/formatsbr.c - yech!
 */
#ifdef LBL
extern struct msgs *fmt_current_folder;	
#endif

/*
 * prototypes
 */
void clear_screen(void);  /* from termsbr.c */


main (int argc, char **argv)
{
    int clearflag = 0, hdrflag = 0, ontty;
    int state, width = 0, msgp = 0, msgnum;
    int revflag = 0; 		/* used to be #ifdef BERK */
    int bits;			/* should match mp->msgstats[] type */
    long clock;
    char *cp, *maildir, *file = NULL, *folder = NULL;
    char *form = NULL, *format = NULL, buf[100], **ap;
    char **argp, *nfs, *arguments[MAXARGS], *msgs[MAXARGS];
    struct msgs *mp;
    FILE *in;

#ifdef LOCALE
	setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    mts_init (invo_name);
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while ((cp = *argp++)) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown", cp);

		case HELPSW: 
		    sprintf (buf, "%s [+folder] [msgs] [switches]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);

		case CLRSW: 
		    clearflag++;
		    continue;
		case NCLRSW: 
		    clearflag = 0;
		    continue;

		case FORMSW: 
		    if (!(form = *argp++) || *form == '-')
			adios (NULL, "missing argument to %s", argp[-2]);
		    format = NULL;
		    continue;
		case FMTSW: 
		    if (!(format = *argp++) || *format == '-')
			adios (NULL, "missing argument to %s", argp[-2]);
		    form = NULL;
		    continue;

		case HEADSW: 
		    hdrflag++;
		    continue;
		case NHEADSW: 
		    hdrflag = 0;
		    continue;

		case WIDSW: 
		    if (!(cp = *argp++) || *cp == '-')
			adios (NULL, "missing argument to %s", argp[-2]);
		    width = atoi (cp);
		    continue;
		case REVSW:
		    revflag++;
		    continue;
		case NREVSW:
		    revflag = 0;
		    continue;

		case FILESW:
		    if (!(cp = *argp++) || (cp[0] == '-' && cp[1]))
			adios (NULL, "missing argument to %s", argp[-2]);
		    if (strcmp (file = cp, "-"))
			file = path (cp, TFILE);
		    continue;
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULL, "only one folder at a time!");
	    else
		folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    msgs[msgp++] = cp;
    }


    if (!m_find ("path"))
	free (path ("./", TFOLDER));
    nfs = new_fs (form, format, FORMAT);	/* must be before chdir() */

    if (file) {
	if (msgp)
	    adios (NULL, "\"msgs\" not allowed with -file");
	if (folder)
	    adios (NULL, "\"+folder\" not allowed with -file");

	/*
	 * we've been asked to scan a maildrop file
	 */
	if (strcmp (file, "-")) {
	    in = fopen (file, "r");
	    if (in == NULL)
		adios (file, "unable to open");
	}
	else {
	    in = stdin;
	    file = "stdin";
	}

#ifndef	JLR
	if (hdrflag) {
	    time (&clock);
	    printf ("Folder %-32s%s\n\n", file,
		    dasctime (dlocaltime (&clock), TW_NULL));
	}
#endif	/* JLR */
	m_unknown (in);
	for (msgnum = 1; ; ++msgnum) {
	    state = scan (in, msgnum, -1, nfs, width, 0, 0,
		    hdrflag ? file : (char *) 0, 0L, 1);
	    if (state != SCNMSG && state != SCNENC)
		break;
	}
	fclose (in);
	done (0);
    }

    if (!msgp)
	msgs[msgp++] = "all";
    if (!folder)
	folder = m_getfolder ();
    maildir = m_maildir (folder);

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to");
    if (!(mp = m_gmsg (folder)))
	adios (NULL, "unable to read folder %s", folder);
    if (mp->hghmsg == 0)
	adios (NULL, "no messages in %s", folder);

    for (msgnum = 0; msgnum < msgp; msgnum++)
	if (!m_convert (mp, msgs[msgnum]))
	    done(1);
    m_setseq (mp);

    m_replace (pfolder, folder);
    m_sync (mp);
    m_update ();

    if (cp = m_find(usequence)) { /* set bits for each unseen sequence */
	char *dp = NULL;

	bits = 0;
	for (ap = brkstring(dp = getcpy(cp), " ", "\n"); ap && *ap; ap++)
	    bits |= m_seqflag(mp, *ap);

	if (dp)
	    free(dp);
    }

    ontty = isatty (fileno (stdout));

#ifdef	LBL
    else
	fmt_current_folder = mp;
#endif

    for (msgnum = revflag ? mp->hghsel : mp->lowsel;
	    (revflag ? msgnum >= mp->lowsel : msgnum <= mp->hghsel);
	    msgnum += revflag ? (-1) : 1)
	if (mp->msgstats[msgnum] & SELECTED) {
	    if ((in = fopen (cp = m_name (msgnum), "r")) == NULL) {
#ifdef	notdef
		if (errno != EACCES)
#endif
		    admonish (cp, "unable to open message");
#ifdef	notdef
		else
		    printf ("%*d  unreadable\n", DMAXFOLDER, msgnum);
#endif
		continue;
	    }

#ifndef	JLR
	    if (hdrflag) {
		time (&clock);
		printf ("Folder %-32s%s\n\n", folder,
			dasctime (dlocaltime (&clock), TW_NULL));
	    }
#endif	/* JLR */
	    switch (state = scan (in, msgnum, 0, nfs, width,
			msgnum == mp->curmsg,
			mp->msgstats[msgnum] & bits,
			hdrflag ? folder : (char *)0, 0L, 1)) {
		case SCNMSG: 
		case SCNENC: 
		case SCNERR: 
		    break;

		default: 
		    adios (NULL, "scan() botch (%d)", state);

		case SCNEOF: 
#ifdef	notdef
		    printf ("%*d  empty\n", DMAXFOLDER, msgnum);
#else
		    advise (NULL, "message %d: empty", msgnum);
#endif
		    break;
	    }
	    hdrflag = 0;
	    fclose (in);
	    if (ontty)
		fflush (stdout);
	}
#ifdef	LBL
    m_sync (mp);	/* because formatsbr might have made changes */
#endif


    if (clearflag)
	clear_screen ();

    done (0);
}
