
/*
 * pidwait.c -- wait for child to exit
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	/* lint */

#include "../h/nmh.h"
#include "../h/mh.h"
#include <signal.h>
#include <stdio.h>

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

int
pidwait (pid_t id, int sigsok)
{
    pid_t pid;
    RETSIGTYPE (*istat)(), (*qstat)();

#ifdef WAITINT
    int status;
#else
    union wait status;
#endif

    if (sigsok == NOTOK) {
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
    }

#ifdef HAVE_WAITPID
    pid = waitpid(id, &status, WUNTRACED);
#else
    while ((pid = wait(&status)) != NOTOK && pid != id)
	continue;
#endif

    if (sigsok == NOTOK) {
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
    }

#ifdef WAITINT
    return (pid == NOTOK ? NOTOK : status);
#else
    return (pid == NOTOK ? NOTOK : status.w_status);
#endif
}
