
/*
 * discard.c -- discard output on a file pointer
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	/* lint */

#include "../h/nmh.h"
#include "../h/mh.h"
#include <stdio.h>

#ifdef SYS5
# include <sys/types.h>
# include <sys/ioctl.h>
#endif

#ifdef HAVE_TERMIOS_H
# include <termios.h>
#else
# ifdef HAVE_TERMIO_H
#  include <termio.h>
# else
#  include <sgtty.h>
# endif
#endif

void
discard (FILE *io)
{
#ifdef HAVE_TERMIOS_H
    struct termios tio;
#else
# ifdef HAVE_TERMIO_H
    struct termio tio;
# else
    struct sgttyb tio;
# endif
#endif

    if (io == NULL)
	return;

#ifdef HAVE_TERMIOS_H
    tcflush (fileno(io), TCOFLUSH);
#else
# ifdef HAVE_TERMIO_H
    if (ioctl (fileno(io), TCGETA, &tio) != NOTOK)
	ioctl (fileno(io), TCSETA, &tio);
# else
    if (ioctl (fileno(io), TIOCGETP, (char *) &tio) != NOTOK)
	ioctl (fileno(io), TIOCSETP, (char *) &tio);
# endif
#endif

#ifdef _FSTDIO
    fpurge (io);
#else
    if (io->_ptr = io->_base)
	io->_cnt = 0;
#endif
}

