.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MH-ALIAS %manext5% MH.6.8 [%nmhversion%]
.SH NAME
mh-alias \- alias file for nmh message system
.SH SYNOPSIS
.in +.5i
.ti -.5i
any \fInmh\fR command
.in -.5i
.SH DESCRIPTION
This describes both \fInmh\fR personal alias files and
the global alias file for nmh mail delivery, the file

	%etcdir%/MailAliases

It does \fBnot\fR describe aliases files used by the message transport system.
Each line of the alias file has the format:

	alias : address\-group
.br
or
.br
	alias ; address\-group
.br
or
.br
	< alias\-file
.br
or
.br
	; comment
.br

where:

	address\-group  :=  address\-list
.br
		       |   \*(lq<\*(rq file
.br
		       |   \*(lq=\*(rq UNIX\-group
.br
		       |   \*(lq+\*(rq UNIX\-group
.br
		       |   \*(lq*\*(rq

.br
	address\-list   :=  address
.br
		       |   address\-list, address
.br

Continuation lines in alias files end with `\\' followed by the newline
character.

Alias\-file and file are UNIX file names.  UNIX\-group is a group name
(or number) from \fI/etc/group\fR.  An address is a \*(lqsimple\*(rq
Internet\-style address.  Througout this file, case is ignored, except
for alias\-file names.

If the line starts with a `<', then the file named after the `<' is
read for more alias definitions.  The reading is done recursively, so a
`<' may occur in the beginning of an alias file with the expected results.

If the address\-group starts with a `<', then the file named after the
`<' is read and its contents are added to the address\-list for the alias.

If the address\-group starts with an `=', then the file \fI/etc/group\fR
is consulted for the UNIX\-group named after the `='.  Each login name
occurring as a member of the group is added to the address\-list for
the alias.

In contrast, if the address\-group starts with a `+', then the file
\fI/etc/group\fR is consulted to determine the group\-id of the
UNIX\-group named after the `+'.  Each login name occurring in the
\fI/etc/passwd\fR file whose group\-id is indicated by this group is
added to the address\-list for the alias.

If the address\-group is simply `*', then the file \fI/etc/passwd\fR is
consulted and all login names with a userid greater than some magic number
(usually 200) are added to the address\-list for the alias.

In match, a trailing * on an alias will match just about anything
appropriate.  (See example below.)

An approximation of the way aliases are resolved at posting time is
(it's not really done this way):

.in +.5i
1) Build a list of all addresses from the message to be delivered,
eliminating duplicate addresses.

2) If this draft originated on the local host, then for those addresses in
the message that have no host specified, perform alias resolution.

3) For each line in the alias file, compare \*(lqalias\*(rq against all of
the existing addresses.  If a match, remove the matched \*(lqalias\*(rq
from the address list, and add each new address in the address\-group to
the address list if it is not already on the list.  The alias itself is
not usually output, rather the address\-group that the alias maps to is
output instead.  If \*(lqalias\*(rq is terminated with a `;' instead of
a `:', then both the \*(lqalias\*(rq and the address are output in the
correct format.  (This makes replies possible since \fInmh\fR aliases
and personal aliases are unknown to the mail transport system.)
.in -.5i

Since the alias file is read line by line, forward references work, but
backward references are not recognized, thus, there is no recursion.

.ne 10
\fBExample:\fR
.nf
.in +.5i
<%etcdir%/BBoardAliases
sgroup: fred, fear, freida
b-people: Blind List: bill, betty;
fred: frated@UCI
UNIX\-committee: <unix.aliases
staff: =staff
wheels: +wheel
everyone: *
news.*: news
.in -.5i
.fi

The first line says that more aliases should immediately be read from
the file \fI%etcdir%/BBoardAliases\fR.  Following this, \*(lqfred\*(rq
is defined as an alias for \*(lqfrated@UCI\*(rq, and \*(lqsgroup\*(rq
is defined as an alias for the three names \*(lqfrated@UCI\*(rq,
\*(rqfear\*(rq, and \*(rqfreida\*(rq.
.sp
The alias \*(lqb-people\*(rq is a blind list which includes the addresses
\*(lqbill\*(rq and \*(lqbetty\*(rq; the message will be delieved to those
addresses, but the message header will  show only \*(lqBlind List: ;\*(rq
(not the addresses).
.sp
Next, the definition of \*(lqUNIX\-committee\*(rq is given by
reading the file \fIunix.aliases\fR in the users \fInmh\fR directory,
\*(lqstaff\*(rq is defined as all users who are listed as members of the
group \*(lqstaff\*(rq in the \fI/etc/group\fR file, and \*(lqwheels\*(rq
is defined as all users whose group\-id in \fI/etc/passwd\fR is equivalent
to the \*(lqwheel\*(rq group.
.sp
Finally, \*(lqeveryone\*(rq is defined as all users with a user\-id
in \fI/etc/passwd\fR greater than 200, and all aliases of the form
\*(lqnews.<anything>\*(rq are defined to be \*(lqnews\*(rq.

The key thing to understand about aliasing in \fInmh\fR is that aliases
in \fInmh\fR alias files are expanded into the headers of messages posted.
This aliasing occurs first, at posting time, without the knowledge of the
message transport system.  In contrast, once the message transport system
is given a message to deliver to a list of addresses, for each address
that appears to be local, a system\-wide alias file is consulted.  These
aliases are \fBNOT\fR expanded into the headers of messages delivered.
.Hh
To use aliasing in \fInmh\fR quickly, do the following:

.in +.5i
First, in your \fI\&.mh\(ruprofile\fR, choose a name for your alias
file, say \*(lqaliases\*(rq, and add the line:

.nf
.in +.5i
Aliasfile: aliases
.\" ali: \-alias aliases
.\" send: \-alias aliases
.\" whom: \-alias aliases
.in -.5i
.fi

Second, create the file \*(lqaliases\*(rq in your \fInmh\fR directory.

Third, start adding aliases to your \*(lqaliases\*(rq file as appropriate.
.in -.5i
.Fi
^%etcdir%/MailAliases~^global nmh alias file
.Pr
^Aliasfile:~^For a default alias file
.Sa
ali(1), send(1), whom(1), group(5), passwd(5), conflict(8), post(8)
.De
None
.Co
None
.Bu
Although the forward-referencing semantics of \fImh\-alias\fR files
prevent recursion, the \*(lq<\ alias\-file\*(rq command may defeat this.
Since the number of file descriptors is finite (and very limited), such
infinite recursion will terminate with a meaningless diagnostic when
all the fds are used up.
.sp
Forward references do not work correctly inside blind lists.
.En
