#!/home/bwelch/bin/wish -f
# Cursor chapter

# This displays all the X11 cursors.
# However, it seems to work better with Tk 3.6

set file cursorfont.h	;# From X11 include directory

. config -cursor gumby

frame .top ; pack .top -side top -fill x -expand true
label .top.ex -text "Cursors and their names.  E.g., listbox \$l -cursor hand2"
button .top.quit -text Quit -command exit -cursor pirate
pack .top.quit -side right
pack .top.ex -side top -fill x

foreach col {1 2 3 4} {
    frame .$col -bd 0
    pack .$col -side left -fill y
}
set in [open $file]
set row 1
set col 1
foreach line [split [read $in] \n] {
    if [regexp {^#define XC_([^ ]+) ([0-9]+)} $line match name value] {
	if {$name == "num_glyphs"} {
	    set num_glyphs $value
	    set maxrow [expr $num_glyphs/8 + 1]
	    continue
	}
	if {$value == 0} {
	    set value 1	;# fudge on first cursor to avoid NULL
	}
	set f [frame .$col.$row]
	label $f.l -text $name -width 18 -anchor w
	label $f.b -text [format "%c" $value] -font cursor -bg white -width 1
	pack $f.b $f.l -side left
	pack $f -side top
	update
	incr row
	if {$row > $maxrow} {
	    incr col
	    set row 1
	}
    }
}
close $in
