# Canvas chapter
proc Init {} {
	# Create and pack the canvas
	canvas .c -width 400 -height 100
	pack .c
	# Create a text object on the canvas
	.c create text 50 50 -text "Hello, World!" -tag movable
	# Bind actions to the text object
	.c bind movable <Button-1> {Mark %x %y %W}
	.c bind movable <B1-Motion> {Drag %x %y %W}
}

proc Mark { x y w } {
	global state
	set state($w,obj) [$w find closest $x $y]
	set state($w,x) $x
	set state($w,y) $y
}
proc Drag { x y w } {
	global state
	set dx [expr $x - $state($w,x)]
	set dy [expr $y - $state($w,y)]
	$w move $state($w,obj) $dx $dy
	set state($w,x) $x
	set state($w,y) $y    
}
