/*
**
** Copyright (C) 1994 Swedish University Network (SUNET)
**
**
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**
**                                        Martin.Wendel@udac.uu.se
**                                        Torbjorn.Wictorin@udac.uu.se
**
**                                        UDAC	
**                                        P.O. Box 174
**                                        S-751 04 Uppsala
**                                        Sweden
**
*/


%a 4000
%o 8000
%k 100
%n 100
%p 500
%e 200

WHITESPACE	[ \t]
COMMENT		[\#]
COLON		[\:]
COMMA		[\,]
EQUALS		[\=]
EOL		[\n]
EOR		[\;]
QSTRING		[\"][^\"]*[\"]
STRING		[A-Za-z0-9\-_\.\@\?\*\/\$]+

%%

{WHITESPACE}++	{ /* Eat whitespace */	}
{COMMENT}[^\n]*	{ /* Eat comments   */	}
{EOL}		{ line_count++;  	}
{EQUALS}	{ return	EQUALS; }
{COLON}		{ return	COLON; 	}
{COMMA}		{ return	COMMA;	}
{EOR}		{ return	EOR;	}
charset		{ return	CHARSET;}
textenc         { return        TEXTENC;}
henc            { return        HENC;   }
format		{ return	FORMAT; }
bin		{ return	BIN; 	}
group		{ return	GROUP;	}
member		{ return	MEMBER; }
match		{ return	MATCH;  }
mailer		{ return	MAILER;  }

{QSTRING}	{ int	qstringlen;
		  yylval.string	= strcpy(Yalloc(strlen(&yytext[1])+1),
					 &yytext[1]);
		  qstringlen	= strlen(yylval.string);
		  yylval.string[qstringlen-1]	= 0;
		  return	QSTRING;
		}

{STRING}	{ yylval.string = strcpy(Yalloc(strlen(yytext)+1),yytext);
		  return	STRING; 
		}

%%
