;;;
;;; $Id: irchat-vars.el,v 1.4 1994/02/23 15:05:00 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(provide 'irchat-vars)

;;;
;;; user modifiable variables
;;;

(defvar irchat-command-window-height 4
  "*How large should Command window be on startup.")

(defvar irchat-want-traditional nil
  "*Do we want Irchat to look like IrcII.")

(defvar irchat-variables-file "~/.irchat_vars.el"
  "*Where to look for variables. Helps to remove clutter from your .emacs.
This feature is most likely to dissappear in near future. The preferred 
way is to put irchat variables on .emacs or file loaded from there.")
 
(defvar irchat-server (or (getenv "IRCSERVER") "irc.eunet.fi")
  "*Name of the host running the IRC server. 
Value initialized from the IRCSERVER environment variable if one is set")

(defvar irchat-service 
  (let ((ircport-env (getenv "IRCPORT")))
    (if ircport-env
	(if (> (string-to-int ircport-env) 0)
	    (string-to-int ircport-env)
	  ircport-env)
      6667))
  "*IRC service name or (port) number.")

(defvar irchat-dcc-program "dcc"
  "*Name of dcc-program.")

(defvar irchat-dcc-directory "~/tmp" 
  "*Directory where irchat-dcc puts its files.")

(defvar irchat-dcc-port 1200 
  "*Default port for DCC operations.")

(defvar irchat-nickname (or (getenv "IRCNICK") (user-real-login-name))
  "*The nickname you want to use in IRC.
Default is the environment variable IRCNICK, or your login name.")

(defvar irchat-startup-channel nil
  "*The channel to join automatically at startup.
If nil, do not join any channel.")

(defvar irchat-myformat-string "> "
  "*Format for own messages.")

(defvar irchat-format-string ">%s<"
  "*Format string for private messages being sent.")

(defvar irchat-format-string1 "=%s="
  "*Format string for arriving private messages.")

(defvar irchat-format-string2 "<%s>"
  "*Format string for arriving messages to current channel.")

(defvar irchat-format-string3 "<%s:%s>"
  "*Format string for arriving messages to current channel from outside the channel.")

(defvar irchat-format-string4 "(%s)"
  "*Format string for arriving messages to other channel from outside the channel.")

(defvar irchat-format-string5 "(%s:%s)"
  "*Format string for arriving messages to other channel from outside the channel.")

(defvar irchat-signoff-msg ""
  "*Default signoff message")

(defvar irchat-beep-on-bells nil
  "*If non-nil, and the IRC Dialogue buffer is not selected in a window,
an IRC message arriving containing a bell character, will cause you
to be notified.
If value is 'always, an arriving bell will always cause a beep (or flash).")

(defvar irchat-file-accept nil
  "*Do we accept files.")

(defvar irchat-file-confirm-save nil
  "*Do we want confirmation on saving files.")

(defvar irchat-client-userinfo "No user information given."
  "*Userinfo message given to anyone asking.")

(defvar irchat-timestamp-interval nil
  "*Interval in minutes between timestamps in dialogue-buffer, nil for none.")

(defvar irchat-timestamp-format "*** Time: %s"
  "*Format-string for timestamp.")

(defvar irchat-send-convert-list nil 
  "*Convert characters before sending to server." )

(defvar irchat-receive-convert-list nil
  "*Convert characters after receiving from server." )

(defvar irchat-global-names nil
  "*Set this to T if you want irchat to be able to complete user and 
channel names. If NIL given, irchat does not do global names polling, 
thus causing much less network traffic, but then it is only able to 
complete names on channels you have joined. If number given, it is the
internal between two successive polls.

Notice: There are some gotchas here.
  1. The server sendq is by default 20k and globals names maybe about 30k
     at the time this is written. The NAMES query may cause server to 
     drop the client because of flooding.
  2. The namreply (353) handler is called pretty often and it causes some
     garbage even if it is heavily optimized. You emacs will eat a lot of
     cpu if this is enabled.")

;;;
;;; eof
;;;
