;;;
;;; $Id: irchat-inlines.el,v 1.1 1993/07/12 01:41:49 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(require 'defsubst)

(provide 'irchat-inlines)

(defsubst string-list-ci-memberp (thing list)
  "returns t if thing is member of list, not funcallable"
  (let ((item (car list))
	(uthing (upcase thing)))
    (while (and item (not (string-equal uthing (upcase item))))
      (setq item (car list)
	    list (cdr list)))
    item))

(defsubst string-list-memberp (thing list)
  "returns t if thing is member of list, not funcallable"
  (let ((item (car list)))
    (while (and item (not (string-equal thing item)))
      (setq item (car list)
	    list (cdr list)))
    item))

(defsubst string-list-ci-delete (thing list)
  (let ((uthing (upcase thing))
	(item (car list))
	(result nil))
    (while item
      (if (not (string-equal (upcase item) uthing))
	  (setq result (nconc result (list item))))
      (setq list (cdr list)
	    item (car list)))
    result))

(defsubst string-list-delete (thing list)
  (let ((item (car list))
	(result nil))
    (while item
      (if (not (string-equal item thing))
	  (setq result (nconc result (list item))))
      (setq list (cdr list)
	    item (car list)))
    result))

(defsubst list-to-assoclist (list)
  (let ((result nil) (item (car list)))
    (while item
      (setq result (cons (list item) result)
	    list (cdr list)
	    item (car list)))
    result))

(defsubst irchat-next-line (&optional n)
  (if (= (point) (point-max))
      (newline))
  (forward-line n))
