;;; zenirc-meditate.el --- admonish others for disturbing your meditation

;; Copyright (C) 1995 Noah S. Friedman

;; Author: Noah Friedman <friedman@prep.ai.mit.edu>
;; Maintainer: friedman@prep.ai.mit.edu
;; Keywords: zenirc, extensions
;; Created: 1995-04-09

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:
;;; Code:

(require 'zenirc)

(defvar zenirc-meditate-mode t)
(make-variable-buffer-local 'zenirc-meditate-mode)

(defvar zenirc-meditate-response-percentage 5)

(defvar zenirc-meditate-function 'zenirc-meditate-random-response)

(defvar zenirc-meditate-response-list
  '("Activity through inactivity."
    "Don't bother."
    "Enlightenment does not come from typing."
    "Enlightenment does not require a keyboard."
    "Hair will grow on your palms if you keep typing."
    "Meditate, or die."
    "Once a student typed too much and died."
    "Stop fidgeting, you're bothering the others."
    "The keyboard is sure to block your mind."
    "Will you stop the infernal racquet and meditate!?"
    "Your fingers will destroy your meditation."
    "Your keyboard is not the path to enlightenment."
    "Your typing detracts from your enlightenment."))

;; Changing this to NOTICE will generally avoid loops from other clients
;; that also load this.  But that's less fun.
(defvar zenirc-meditate-response-type "PRIVMSG")

(defun zenirc-meditate-mode (&optional prefix)
  (interactive "P")
  (setq zenirc-meditate-mode (>= (prefix-numeric-value prefix) 0))
  (cond ((not (interactive-p)))
        (zenirc-meditate-mode
         (message "zenirc-meditate-mode is enabled"))
        (t
         (message "May you meditate as well in real life.  Get one.")))
  zenirc-meditate-mode)

(defun zenirc-meditate-random-response (parsedmsg)
  (nth (abs (% (random) (length zenirc-meditate-response-list)))
       zenirc-meditate-response-list))

;; parsedmsg[1]: from
;; parsedmsg[2]: to
;; parsedmsg[3]: text of message
(defun zenirc-meditate (proc parsedmsg)
  (and zenirc-meditate-mode
       (< (% (abs (random)) 100) zenirc-meditate-response-percentage)
       (let ((to (if (zenirc-names-equal-p (aref parsedmsg 2) zenirc-nick)
                     ;; message was private; reply to sender
                     (zenirc-extract-nick (aref parsedmsg 1))
                   ;; message was public. reply to channel.
                   (aref parsedmsg 2)))
             (rant (funcall zenirc-meditate-function parsedmsg)))
         (zenirc-message proc 'meditate-sent to rant)
         (process-send-string proc (format "%s %s :%s\n"
                                           zenirc-meditate-response-type
                                           to rant)))))


(zenirc-add-hook 'zenirc-server-PRIVMSG-hook 'zenirc-meditate 'append)

(zenirc-lang-store-catalog-entry
 'meditate-sent "[info] Sent to %s: %s\n" 'english)

(provide 'zenirc-meditate)

;; zenirc-meditate.el ends here
