;;; zenirc-latin.el --- Latin message catalog for ZenIRC

;; Copyright (C) 1993, 1994 Ben A. Mesander

;; Author: Richard Todd <rmtodd@servalan.servalan.com>
;; Maintainer: Noah Friedman <friedman@prep.ai.mit.edu>
;; Keywords: extensions
;; Created: 1994-02-28

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;; "i like latin-mode, it's like operating a trojan horse or something."
;;   -- Dave Archer <dmarcher@acsu.buffalo.edu>

;; "with zenirc-latin-mode, a netsplit reminds me of the part in carmina
;;  burana where everyone's drinking." -- Dave Archer

;; "god, i love the latin mode.. makes me feel like caligula" -- James Price

;;; Code:

(require 'zenirc)

(zenirc-lang-define-catalog 'latin
 '((join_you . "[info] Apud %s iniis.\n") ; your channel join message
   (join . "[info] %s apud %s iniit.\n") ; channel join message
   (s001 . "[info] Tempus tuum perdis.\n") ; welcome to irc message
   (s002 . "[info] Servum IRC tuum %s (%s) est.\n") ; server name & version #
   (s003 . "[info] Diem %s servum factum est.\n") ; when the server was built
   (s211 . "[info] %s connectio %s momentibus erat.\nMissi : %s/%s, Recepti: %s/%s, Mittendi: %s\n")
   (s212 . "[info] %s\t->\ttempus: %s\tbytes: %s\n") ; command stats
   (s215 . "[info] %s machina/nomen:\t%s/%s\n") ; I-lines
   (s216 . "[info] K machina/nomen clientis:\t%s/%s\n") ; K-lines
   (s219 . "[info] /stats perfectus est.\n") ; end of /stats
   (s221 . "[info] Tuus modus  %s nunc est.\n") ; user mode
   (s241 . "[info] LEAF hostmask/altitudo:\t\t%s/%s\n") ; L-lines
   (s243 . "[info] %s cognomen/login@machina:\t%s/%s\n") ; O-lines or o-lines
   (s244 . "[info] HUB  hostmask/nomen servi:\t%s/%s\n") ; H-lines
   ;; # users on connect message
   (s251 . "[info] %s clientes visibiles et %s clientes invisibles apud %s serva sunt.\n")
   (s252 . "[info] %s nothi pravi adsunt.\n") ; irc operators msg
   (s253 . "[info] %s conjunctiones incognitae sunt.\n") ; unk connects msg
   (s254 . "[info] %s fora sunt.\n")    ; number of channels
   ;; # of clients and servers
   (s255 . "[info] %s clientes et %s serva huic servo loquiuntur.\n")
   (s256 . "[info] Descriptio procurationis %s:\n") ; admin info
   (s301 . "[info] %s abest: %s\n")     ; someone is away
   (s302 . "[info] identificatio: %s.\n") ; userhost reply
   (s303 . "[info] Tempus perdit nunc: %s\n") ; ison reply
   (s305 . "[info] Nuntio te non abesse.\n")
   (s306 . "[info] Nuntio te abesse.\n")
   (s311 . "[info] %s (%s@%s) %s est.\n") ; user part of /whois list
   (s312 . "[info] %s apud servum %s (%s)\n") ; server part of /whois list
   (s313 . "[info] %s nothus pravus est.\n") ; /whois operator status
   (s314 . "[info] %s (%s@%s)  %s erat.\n") ; user part of /whowas list
   (s315 . "[info] /who perfectus est.\n") ; end of /who list replies
   (s318 . "[info] /whois perfectus est.\n") ; end of /whois list replies
   (s317 . "[info] %s per %s quietus erat.\n") ; /whois idle time
   (s319 . "[info] %s adest in: %s\n")  ; channel part of whois data
   (s321 . "[info] Forum\tQuot Clientes?\tRes\n") ; header for LIST cmd
   (s322 . "[info] %s\t%s\t%s\n")       ; each channel in LIST cmd
   (s323 . "[info] /list perfectus est.\n") ; trailer for LIST cmd
   (s324 . "[info] Modus %s: %s %s.\n") ; channel mode
   (s331 . "[info] %s nullam rem habet.\n") ; no topic message
   (s332 . "[info] Res %s : %s\n")      ; topic message
   (s341 . "[info] %s in %s invitas.\n") ; invite reply
   (s342 . "[info] %s tempus perdere rogas.\n") ; summon reply
   (s351 . "[info] Version: %s %s %s.\n") ; version reply
   ;; header for /who list reply
   ;; Bleah, Latin doesn't really have a good short word for 'nickname', so
   ;; we'll invent one.
   (s352_header . "[info] Cognomen Status Nomen Fori     Login et Machina        Nomen\n")
   (s352 . "[info] %-9s %-3s  %-15s %s@%s (%s)\n") ; /who list reply
   (s353 . "[info] Homines in %s: %s\n") ; displayed after channel join
   (s364 . "[info] %s %s %s\n")         ; /links reply
   (s365 . "[info] /links perfectus est.\n") ; end of /links reply
   (s367 . "[info] %s interdicit %s.\n") ; banlist reply
   (s368 . "[info] Tabula interdictionum perfecta est.\n") ; end of banlist
   (s371 . "[info] %s\n")               ; info reply
   (s372 . "[motd] %s\n")               ; message of the day
   (s375 . "[motd] Nuntius hodiernus:\n") ; start of motd
   (s376 . "[motd] Nuntius hodiernus perfectus est.\n") ; end of motd
   (s381 . "[info] Nunc nothus pravus est.\n") ; irc op status
   ;; Yeah, right, like there's a word for `rehash' in Latin.
   (s382 . "[info] Rehashit: %s\n")
   (s391 . "[info] Dies apud servum %s: %s.\n") ; TIME reply
   (s392 . "[info] Login Terminal  Machina\n") ; header for users rpl
   (s393 . "[info] %s\n")               ; body of users rpl
   (s395 . "[info] Nemo adest.\n")      ; nobody for users rpl
   (s401 . "[info] %s nec cognomen nec forum est.\n") ; no such nick/chan
   (s402 . "[info] Servum %s nescio.\n") ; there is no such server
   (s403 . "[info] Forum %s nescio.\n") ; there is no such channel
   (s404 . "[info] %s loqui non potes.\n") ; you can't send to channel
   (s405 . "[info] Plura fora quam loqui potes: %s.\n") ; too many channels
   (s406 . "[info] %s servum nescit.\n") ; no whowas data
   (s407 . "[info] Receptores duplices  ; nuntium non misit: %s\n") ; user@host
   (s411 . "[info] Nullus receptor adfuit.\n") ; no recipient given
   (s412 . "[info] Nullus nuntius adfuit.\n") ; you didn't send anything.
   (s413 . "[info] Nullum regnum supremum adfuit: %s\n") ; no toplevel domain
   (s414 . "[info] Regnum vitiosum est: %s.\n") ; wild toplevel
   (s421 . "[info] Stercus est: %s.\n") ; you sent server spam
   (s422 . "[info] Quidam nothus pravus imperitus est; nuntium hodiernum non fecit.\n")
   (s423 . "[info] Quidam nothus pravus imperitus est; procurationem non descripsit.\n")
   (s431 . "[info] Nullus cognomen adfuit.\n") ; you didn't provide a nick
   (s432 . "[info] Cognomen vitiosum est: %s.\n") ; invalid nick
   (s433 . "[info] Aliquis cognomen %s iam utebatur.\n") ; invalid nick
   (s436 . "[info] Concursus cognominum: %s.\n") ; nickicide
   (s441 . "[info] %s in %s non est.\n") ; can't do it to those not present
   (s442 . "[info] In %s non es.\n")    ; you can't do that dave.
   (s443 . "[info] %s iam in %s est.\n") ; invite error
   (s444 . "[info] %s non conjunctus est.\n") ; SUMMON reply
   ;; disabled summon
   (s445 . "[info] Te /summon uti aliqui nothus pravus non permittit.\n")
   ;; disabld users
   (s446 . "[info] Te /users uti aliqui nothus pravus non permittit.\n")
   (s451 . "[info] Nondum perscripsit.\n") ; gotta do the USER NICK thing
   (s461 . "[info] Parum parameteres: %s\n")
   (s462 . "[info] Non perscriptere iterum potes.\n") ; cannot USER twice
   ;; server refuses this client
   (s463 . "[info] Te connectere aliqui nothus pravus cerritus non permittit.\n")
   (s464 . "[info] Tessera vitiosa est.\n") ; bad PASS command
   (s465 . "[info] Hoc servam uti non tibi licet.\n") ; creep
   (s467 . "[info] Tessera huius fori iam adest.\n") ; chan key set already
   (s471 . "[info] Apud %s inire non potes (plures clientes).\n")
   (s472 . "[info] Modum %s nescio.\n") ; duh
   (s473 . "[info] Apud %s inire non potes (nulla invitatio est).\n")
   (s474 . "[info] Apud %s inire non potes. Interdiceris.\n") ; you're banned
   (s475 . "[info] Apud %s inire non potes (tesseram non habes).\n")
   (s481 . "[info] Hic solum nothos pravos licet.\n") ; oper only
   (s482 . "[info] Censor %s non es.\n")
   (s483 . "[info] Eh! Servum caedere non potes!\n") ; can't kill a server
   (s491 . "[info] Nulli nothi pravi ab tua machina permissi sunt.\n")
   (s501 . "[info] Hanc modum nescio.\n") ; you did something silly
   (s502 . "[info] Modum alii mutare non potes.\n") ; as above
   (ctcp_action . "[actio->%s] %s %s\n")
   (ctcp_clientinfo . "[quaestio] CLIENTINFO ab %s ad %s.\n")
   (ctcp_errmsg . "[quaestio] ERRMSG ab %s ad %s.\n")
   (ctcp_finger . "[quaestio] FINGER ab %s ad %s.\n")
   (ctcp_ping . "[quaestio] PING ab %s ad %s.\n")
   (ctcp_ping_reply . "[reponsum] PING %s %s momentibus abest.\n")
   (ctcp_source . "[quaestio] SOURCE ab %s ad %s.\n")
   (ctcp_time . "[quaestio] TIME ab %s ad %s.\n")
   (ctcp_userinfo . "[quaestio] USERINFO ab %s ad %s.\n")
   (ctcp_version . "[quaestio] VERSION ab %s ad %s.\n")
   (debug . "[debug] %s\n")             ; displayed by debugging code
   (error . "[%s] %s\n")                ; server error message
   (invite . "[info] %s te apud %s invitat.\n") ; invite
   (kick . "[info] %s de %s ejectum est per %s.\n") ; someone was peeved
   (kick_you . "[info] De %s ejectum es per %s.\n") ; loser
   (kill . "[info] Caesus es: %s.")     ; your time is up.
   (mode . "[info] %s modum de %s mutavit: %s\n") ; MODE change
   (nick . "[info] %s cognomen mutavit ad %s.\n") ; nick change
   (nosend . "[info] Nulla victima in nuntios habes.\n") ;
   (notice . "{%s%s} %s\n")             ; NOTICE
   (notice_you . "{%s} %s\n")           ; NOTICE sent to your nick
   (notify_list . "[info] Ei quos exspectas: %s\n") ;
   (notify_on . "[info] %s tempus perdere videbam.\n") ;
   (notify_off . "[info] %s tempus perdere non iam video.\n") ;
   (now_querying . "[info] Victima: %s.\n") ; /query foo
   (part_you . "[info] Exis de: %s (%s)\n") ; your part from channel message
   (part . "[info] %s exiit de %s (%s)\n")  ;part from channel message
   (privmsg . "<%s%s> %s\n")            ; PRIVMSG
   (privmsg_you . "*%s* %s\n")          ; PRIVMSG sent to your nick
   (query . "[quaestio] ab %s ad %s, res %s.\n") ; ctcp query
   (query_unknown . "Mandatum CTCP ignotum.") ; we don't grok this
   (query_unbalanced . "[mala quaestio] ab %s ad %s, res %s.\n")
   (query_unbalanced_reply . "Malum reponsum CTCP.") ; odd number of ^A's
   (quit . "[info] %s tempus perdere intermisit: %s\n") ; user signoff
   (reply . "[reponsum] ab %s ad %s, res %s.\n") ; ctcp reply
   (reply_unbalanced . "[malum reponsum] ab %s ad %s, res %s.\n") ; weird
   (send . "(ad %s missus est)\n")      ; you sent a message/notice
   (send-echo . "(ad %s missus est)")      ; you sent a message/notice
   (server . "[servum] %s\n")           ; unknown server message
   (signal . "[signum in %s]")          ; signal in echo area
   (topic . "[info] %s res %s mutavit: %s\n") ; topic message
   (wallops . "-%s- %s\n")              ; WALLOPS notice
   ))

(provide 'zenirc-latin)

;; zenirc-latin.el ends here
