;;; zenirc-klingon.el 
;;; Waste time on Internet Relay Chat with badly translated Klingon.

;;; Copyright (C) 1993, 1994 Ben A. Mesander

;; Author: David M. Archer <dmarcher@gnu.ai.mit.edu>
;; Maintainer: friedman@prep.ai.mit.edu
;; Keywords: extensions, zenirc
;; Created: 1995-05-07

;; $Id: zenircrcsblahblahhere Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;;; Code:

(require 'zenirc)

(zenirc-lang-define-catalog 
 'klingon
 '((s001 . "[De'] batlhlIj bIchIlqu'lI'\n")  ; wasting time
	 (s002 . "[De'] %s tengchaH QumwI'qoqvam lo' %s\n") ; server is
	 (s003 . "[De'] %s ghItlh tengchaH QumwI'qoqvam\n") ; ??
	 (s200 . "[De'] %s (%s) rarwI' -> %s\n") ; Version jangwI' from /trace
	 (s202 . "[De'] %s H.S. -> %s\n")
	 (s203 . "[De'] %s Sovbe'wI' -> IP address: %s\n") ; Unknown connection
	 (s204 . "[De'] %s DenIb Qatlh -> %s\n") ; Operator connection
	 (s205 . "[De'] %s lo'wI' -> %s\n") ; User connection
	 (s206 . "[De'] %s tengchaH QumwI'qoq -> %s %s %s %s \n") ; Server connection
	 (s208 . "[De'] %s %s -> %s\n") ; New type connection
	 (s209 . "[De'] %s buv -> %s = %s\n") ; What the classes means
	 (s211 . "[De'] %s rartaH lup %s\nSent: %s/%s, Rcvd: %s/%s, SendQ: %s\n")
	 (s212 . "[De'] %s\t->\ttimes: %s\tbytes: %s\n") ; Command stats
	 (s213 . "[De'] C hst/nme/prt/cls: %s/%s/%s/%s\n")      ; C-lines
	 (s214 . "[De'] N hst/nme/prt/cls: %s/%s/%s/%s\n") ; N-lines
	 (s215 . "[De'] %s host/name/class:\t%s/%s/%s\n") ; I-lines
	 (s216 . "[De'] K host/username:\t%s/%s\n") ; K-lines
	 (s217 . "[De'] Q %s/%s/%s/%s/%s\n") ; Q-lines
	 (s218 . "[De'] Class: %s Ping freq: %s Conn.freq: %s Max Links: %s Sendq: %s\n") ; Y-lines
	 (s219 . "[De'] /stats pItlh\n")
	 (s221 . "[De'] %s soHbeHwI'\n")
	 (s241 . "[De'] LEAF hostmask/depth:\t\t%s/%s\n") ; L-lines
	 (s242 . "[De'] %s\n") ; Uptime of server
	 (s243 . "[De'] O pongname/user@host:\t%s/%s\n") ; O-lines
	 (s244 . "[De'] HUB  hostmask/servername:\t%s/%s\n") ; H-lines
	 (s251 . "[De'] naDev tengchaHmay QumwI'meyqoq %s lo'lI' lo'wI'pu' So'be' je %s lo'wI'pu' So' %s tu'lu'\n")
	 (s252 . "[De'] naDev DenIbya'pu' Qatlh %s tu'lu'\n") ; # opers
	 (s253 . "[De'] naDev rarwI' Sovbe' %s tu'lu'\n") ; # links ?
	 (s254 . "[De'] naDev Se'mey %s tu'lu'\n") ; # channels
	 (s255 . "[De'] naDev lo'WI'pu' %s je tengchaHmay QumwI'meyqoq %s tengchaH QumwI'qoqvam rartaH tu'lu'\n")
	 (s256 . "[De'] De' loH %s:\n") ; /admin line 1
	 (s257 . "[De'] %s\n") ; /admin line 2
	 (s258 . "[De'] %s\n") ; /admin line 3
	 (s259 . "[De'] %s\n") ; /admin line 4
	 (s261 . "[De'] %s File -> %s %s\n") ; Logfile trace
	 (s301 . "[De'] %s naDevDaq ghaHbe': %s\n") ; away
	 (s302 . "[De'] userhost: %s\n") ; userhost jangwI'
	 (s303 . "[De'] batlhlIj chIlqu'lI' %s\n") ; ison (losing honor)
	 (s305 . "[De'] naDevDaq soHbe'\n") ; you are not here
	 (s306 . "[De'] naDevDaq soH\n") ; you are here
	 (s311 . "[De'] %s (%s@%s) %s ghaH\n") ; user part of /whois list
	 (s312 . "[De'] %s tengchaH Qumwl'qoq lo'lI' %s (%s) ghaH\n")
	 (s313 . "[De'] %s DenIbya' Qatlh ghaH\n") ; /whois operator status
	 (s314 . "[De'] %s (%s@%s) %s ghaHta'law'\n") ; user part of /whowas list
	 (s315 . "[De'] /who pItlh\n")
	 (s317 . "[De'] %s has been idle %s\n") ; /whois idle time
	 (s318 . "[De'] /whois pItlh\n")
	 (s319 . "[De'] %s lo'lI' Se'mey %sghaH\n") ; channel part of whois data
	 (s321 . "[De'] Se'           lo'wI'pu'  qech\n") ; header for LIST cmd
	 (s322 . "[De'] %-15s %-5s %s\n")  ; each channel in LIST cmd
	 (s323 . "[De'] /list pItlh\n")  ; trailer for LIST cmd
	 (s324 . "[De'] %s 'oHbeHwI' %s %s\n") ; channel mode
	 (s331 . "[De'] %s Se' 'oHbe' qech\n") ; no topic message
	 (s332 . "[De'] %s qech: %s\n")   ; topic message
	 (s333 . "[De'] %s qech %s ghaHbeHta' %s\n") ; topic set time
	 (s341 . "[De'] %s DarI'meH %s\n") ; invite 
	 (s342 . "[De'] %s Datlhob batlh chIl\n") ; summon (ask to lose honor)
	 (s351 . "[De'] tengchaH QumwI'qoq lo': %s %s %s\n") ; version jangwI'
	 (s352_header . "[De'] pong     Dotlh  Se'      lo'wI'@'ejyo' (toghwI' chuq  pong)\n") ; header for /who list jangwI\'
	 (s352 . "[De'] %-9s %-3s  %-15s %s@%s (%s)\n") ; /who list jangwI\'
	 (s353 . "[De'] %s lo'wI'pu' %s\n") ; displayed after Bahnhof eintritt
	 (s364 . "[De'] %s %s %s\n")       ; /links 
	 (s365 . "[De'] /links pItlh\n")  ; end of /links 
	 (s367 . "[De'] %s ghImwI' %s\n")      ; banlist 
	 (s368 . "[De'] QonoS ghImwI' pItlh\n") ; end of banlist 
	 (s371 . "[De'] %s\n")             ; De' 
	 (s372 . "[motd] %s\n")		; message of the day
	 (s375 . "[motd] jabbI'ID'a' tengchaH QumwI'qoqvam:\n") ; start of motd
	 (s376 . "[motd] motd pItlh\n")    ; displayed at end of motd
	 (s381 . "[De'] DenIbya' Qatlh soH\n") ; you are an oper
	 (s382 . "[De'] Hujqa'lI': %s\n")  ; rehash server msg
	 (s391 . "[De'] %s tengchaH QumwI'qoqvam poH: %s\n") ; server's time
	 (s392 . "[De'] png     QumwI'    'ejDo'\n") ; header for users rpl
	 (s393 . "[De'] %s\n")             ; body of users rpl
	 (s395 . "[De'] lo'wI'pu' pagh\n") ; nobody for users rpl
	 (s401 . "[De'] pong joq Se' not: %s\n") ; there is no such pong/chan
	 (s402 . "[De'] tengchaH QumwI'qoq not: %s\n") ; there is no such server
	 (s403 . "[De'] Se' not: %s\n") ; there is no such Bahnhof
	 (s404 . "[De'] %s DangeHlaHbe'\n") ; can't send to channel.
	 (s405 . "[De'] tlhaqlIj chu'Ha'lu'pu': %s\n") ; you're on too many channels
	 (s406 . "[De'] %s pong Sovbe'wI'\n") ; no whowas data
	 (s407 . "[De'] HevwI' rap  ngeHHa'lu'pu': %s\n") ; user@host
	 (s409 . "[De'] mung nobHa'ta'\n") ; ping error 
	 (s411 . "[De'] HevwI' nobHa'ta'\n") ; no recipient given
	 (s412 . "[De'] mu' nobHa'ta'\n") ; you didn't send anything.
	 (s413 . "[De'] No toplevel domain: %s\n") ; no toplevel domain spec
	 (s414 . "[De'] Wildcard in toplevel domain: %s\n") ; wild toplevel
	 (s421 . "[De'] jIHtaHbogh naDev vISovbe': %s\n") ; you sent server spam
	 (s422 . "[De'] motd not (DenIbya' Qatlh tIbach /admin)\n")
	 (s423 . "[De'] loH De' not. (DenIbya' Qatlh yIchup HoH'egh)\n")
	 (s431 . "[De'] pong not\n") ; you didn't provide a name
	 (s432 . "[De'] pong qab: %s\n")
	 (s433 . "[De'] pong lo'lI'vIS: %s\n")
	 (s436 . "[De'] pong paw': %s\n")
	 (s441 . "[De'] %s not %s\n") ; can't do it to those not present
	 (s442 . "[De'] %s Se' Dalo'be'\n") ; not on channel
	 (s443 . "[De'] %s lo'pa' Se' %s.\n") ; invite error
	 (s444 . "[De'] %s naDev not\n") ; SUMMON jangwI\'
	 (s445 . "[De'] DenIbya' Qatlh Duchaw'Ha' /summon\n")
	 (s446 . "[De'] DenIbya' Qatlh Duchaw'Ha' /users\n")
	 (s451 . "[De'] SuSovbe'pu'\n") ; gotta do the USER pong thing
	 (s461 . "[De'] jIHtaHbogh naDev vISovbe': %s\n") ; as 421
	 (s462 . "[De'] bItlhobbe' cha'logh\n") ; cannot USER twice
	 (s463 . "[De'] DenIbya' Qatlh Dararbe'qu'\n") ; cannot connect
	 (s464 . "[De'] jISaHbe'\n") ; bad PASS command
	 (s465 . "[De'] DenIbya' Qatlh Dararbe'qu'\n") ; creep
	 (s467 . "[De'] %s ngoq naDev\n") ; chan key set already
	 (s471 . "[De'] %s Damuvbe'qu' (lo'wI' vuS)\n") ; too many ppl
	 (s472 . "[De'] bIlughbe': %s\n") ; duh
	 (s473 . "[De'] %s Damuvbe'qu' (rI'Se'neH)\n") ; fascist nerds
	 (s474 . "[De'] %s Damuvbe'qu' (ghImwI')\n") ; you're banned
	 (s475 . "[De'] %s Damuvbe'qu' (ngoq qab)\n") ; bad key
	 (s481 . "[De'] DenIbya' Qatlh soHbe'\n") ; oper only
	 (s482 . "[De'] verengan soHbe'\n") ; chanop needed
	 (s483 . "[De'] nuqneH\n") ; can't kill a server
	 (s491 . "[De'] DenIbya' Qatlhpu' naDevbe'\n") ; no o-line
	 (s501 . "[De'] bIlughbe'\n") ; you did something silly
	 (s502 . "[De'] bIlughbe'\n") ; as above
	 (action . "(%s Davengta')\n") ; ctcp action sent
	 (action-echo . "(%s Davengta')") ; ctcp action sent
	 (connect-failed . "[Qagh] rarwI' mevlu'ta' %s %d not  QIj: %s\n")
	 (connect-try . "[De'] jol chu'lu' %s %d\n")
	 (connect-abort . "[De'] rarwI' mevlu'ta'\n")
	 (ctcp_action . "[vang->%s] %s %s\n") ; ctcp ACTION display
	 (ctcp_clientinfo . "[yu'wI'] CLIENTINFO %s lIghaH %s\n")
	 (ctcp_errmsg . "[yu'wI'] ERRMSG %s lIghaH %s\n")
	 (ctcp_finger . "[yu'wI'] FINGER %s lIghaH %s\n")
	 (ctcp_ping . "[yu'wI'] PING %s lIghaH %s\n")
	 (ctcp_ping_reply . "[jangwI'] PING %s Duchuqlaw' lup %s\n")
	 (ctcp_source . "[yu'wI'] SOURCE %s lIghaH %s\n")
	 (ctcp_time . "[yu'wI'] TIME %s lIghaH %s\n")
	 (ctcp_username . "[yu'wI'] USERNAME %s lIghaH %s\n")
	 (ctcp_version . "[yu'wI'] VERSION %s lIghaH %s\n")
	 (debug  . "[reghuluS 'Iwghargh DaHoHlI'] %s\n"); displayed by debug code
	 (error . "[%s] %s\n")              ; server error message
	 (invite . "[De'] %s DurI'lI' %s.\n") ; invite (you are being hailed)
	 (join_you . "[De'] %s Damuvta'\n")
	 (join . "[De'] %s muvta' %s\n")
	 (kick . "[De'] %s: %s vo'ta' %s\n") ; someone was peeved
	 (kick_you . "[De'] %s Duvo'ta' %s\n") ; loser
	 (kill . "[De'] HovDaq lupqu'ta': %s") ; you've been killed (transported into star!)
	 (mode . "[De'] %s ghaHbeHchoH %s: %s\n") ; MODE change
	 (nick . "[De'] %s pong ghaHchoH %s\n") ; pong change
	 (newcatalog . "[De'] vIjatlhlaH %s\n")
	 (nocatalog . "[Qagh] vIjatlhlaHbe' %s\n")
	 (nosend . "[De'] romuluSngan Daghajbe'\n") ; msg not sent
	 (notice . "{%s%s} %s\n")           ; NOTICE
	 (notice_you . "{%s} %s\n")         ; NOTICE sent to your pong
	 (notify_list . "[De'] QonoS ghoq: %s\n")
	 (notify_on . "[De'] %s batlhlchaj chIlqu'lI'\n")
	 (notify_off . "[De'] %s batlhlchaj chIlqu'lI'be'\n")
	 (now_querying . "[De'] %s romuluSnganlI' DaghajchoH\n") ; /query foo
	 (part_you . "[De'] %s Damejta' (%s)\n") ;
	 (part . "[De'] %s mejta' %s (%s)\n") ; part from Bahnhof message
	 (pong . "[De'] %s chuS\n")  ; pong message from server
	 (privmsg . "<%s%s> %s\n")          ; PRIVMSG
	 (privmsg_you . "*%s* %s\n")        ; PRIVMSG sent to your pong
	 (protocol_violation . "[error] The following line is in violation of the IRC protocol.\n[error] Please tell the server administrator:\n%s: %s\n")
	 (query . "[yu'wI'] %s lIghaH %s ngaSwI': %s\n") ; ctcp yu'wI'
	 (query_unknown . "CTCP yu'wI' not")
	 (query_unbalanced . "[tlhaQ Yu'WI'] %s lIghaH %s ngaSwI': %s\n")
	 (query_unbalanced_reply . "CTCP tlhaQ Yu'WI'")
	 (quit . "[De'] %s lupta': %s\n") ; user signoff
	 (reply . "[jangwI'] %s lIghaH %s ngaSwI': %s\n") ; ctcp jangwI'
	 (reply_unbalanced . "[tlhaQ JangwI'] %s lIghaH %s ngaSwI': %s\n")
	 (send . "(%s DangeHta')\n") ; you sent a message/notice
	 (send-echo . "(%s DangeHta')") ; you sent a message/notice
	 (sentinel . "\nZenIRC Hegh: %s\n") ; process sentinel message
	 (server . "[QumwI'] %s\n")         ; unknown server message
	 (signal . "[%s DurI'lI']")        ; signal in echo area
	 (topic . "[De'] %s choHta' qech %s: %s\n") ; topic message
	 (wallops . "-%s- %s\n")            ; WALLOPS notice
	 ))

(provide 'zenirc-klingon)

;;; zenirc-klingon.el ends here

;;; notes:

; lupta'  transport (done)
; Se'  frequency
; Se'mey frequencies
; DenIbya' Qatlh / Denlbya'pu' Qatlh
; naDev DenIbya'pu' Qatlh tu'lu' here (Denlbya'pu') notice(indef)
; tengchaH space station
; QumwI' communications device
; qoq (so-called)

; rarwI' "that which connects" link
; Sovbe'wI' "that which is not known" unknown

; tengchaH QumwI'qoq        server
; tengchaH QumwI'qoqvam     this server
; tengchaHmay Qumwl'meyqoq  servers

; ngeHHa'lu'pu'  nothing sent.

; ghaH him/her
; lo'wI'  user (one who uses)  lo'wI'pu'  (users)
; pItlh done
; ghImwI'  ban (that which exiles)
; soHbeHwI'    your mode 

; muv   join   muvta'    (has joined)


;HIja'	yes
;ghobe'	no
;toH	Well! Aha!
;chay'	How did this happen? / What's going on?
;jIyajbe'	I don't understand.
;jISaHbe'	I don't care.
;qay'be' 	No problem!
;tlhIngan Hol DajatIh'a' Do you speak Klingon?
;tlhIngan Hol vIjatIhlaHbe'	I cannot speak Klingon.
;tlhIngan Hol vIjatIhlaH	I can speak Klingon.
;jIleSnIS	I need rest.
;bIleSnIS	You need rest.
;lu'	Ok.
;naDev qaS wanI' ramqu' There's nothing happening here.
;naDev vo' yIghoS	Go away!
;nuqneH	What do you want? (greeting)
;bIjatlh' e' ylmev Shut up.
;naDev tlhInganpu' tu'lu' There are Klingons around here.
