;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Copyright (c) 1993 by William M. Perry (wmperry@indiana.edu)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Variable definitions for w3
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar w3-gopher-object-viewers
  '(
    ( ?0   ""          w3-gopher-doc)           ; view a document
    ( ?1   ""          w3-gopher-dir)           ; parse out a gopher directory
    ( ?4   " <binhex>" w3-gopher-binary-object) ; save as binary file
    ( ?5   " <DOS>"    w3-gopher-binary-object) ; save as binary file
    ( ?6   " <UU>"     w3-gopher-binary-object) ; save as binary file
    ( ?7   " <?>"      w3-gopher-index-object)
    ( ?8   " <TEL>"    w3-gopher-telnet-object)
    ( ?9   " <bin>"    w3-gopher-binary-object) ; save as binary file
    ( ?s   " <)"       w3-gopher-binary-object) ; save as binary file
    ( ?h   " <html>"   w3-gopher-html)
    ( ?w   " <html>"   w3-gopher-html)
    ( ?I   " <image>"  w3-gopher-image-object)
    ( ?g   " <GIF>"    w3-gopher-image-object)
    )
  "*An assoc list of gopher object types and how to view them")

(defvar w3-doing-gopher nil)

(defvar w3-use-hypertext-gopher nil
  "*Use my gopher interface, and preserve the hypertext interface, or
gopher-mode?  Gopher mode is more complete at this time.")

(defvar w3-bad-port-list
  '("25" "119")
  "*List of ports to warn the user about connecting to.")

(defvar w3-bad-server-list
  '("iicm.tu-graz.ac.at"
    "heplibw3.slac.stanford.edu"
    "cs.indiana.edu"
    "moose.cs.indiana.edu"
    "hoohoo.ncsa.uiuc.edu"
    "www.cis.ohio-state.edu"
    "www.ncsa.uiuc.edu")
  "*Listing of servers that can be interrupted by an HTTP/1.0 request.
Usually just HTTP/0.9 servers with lots of lag from where you are.")

(defvar w3-directory-format 'hypertext
  "*How to format directory listings.

If value is 'hypertext, use directory-files to list them out and
transform them into a hypertext document, then pass it through the
parse like any other document.

If value is 'dired, just pass the directory off to dired using find-file.")

(defvar w3-annotation-marker "<ncsa-annotation-format-1>")
(defconst w3-default-continuation '(w3-uncompress w3-clean-text) 
  "Default action to start with - cleans text and uncompresses if necessary")
(defvar w3-doing-graphic nil "Are we about to retrieve a graphic?")
(defvar w3-link-start-delimiter "[["
  "*Put this at front of link if w3-delimit-links is t")
(defvar w3-link-end-delimiter "]]"
  "*Put this at end of link if w3-delimit-links is t")
(defvar w3-connection-retries 5 "*# of times to try for a connection")
(defvar w3-continuation w3-default-continuation
  "Continuation for parsing document, etc")
(defvar w3-current-annotation nil "URL of document we are annotating...")
(defvar w3-current-file nil "Filename of current document")
(defvar w3-current-isindex nil "Is the current document a searchable index?")
(defvar w3-current-mime-encoding nil "MIME encoding of current document")
(defvar w3-current-mime-type nil "MIME type of current document")
(defvar w3-current-mime-viewer nil "How to view the current MIME doc")
(defvar w3-current-mime-server-type nil "Type of server that sent the doc")
(defvar w3-current-port nil "Port # of the current document")
(defvar w3-current-server nil "Server of the current document")
(defvar w3-current-type nil "We currently in http or file mode?")
(defvar w3-current-last-buffer nil "Last W3 buffer seen before this one")
(defvar w3-default-homepage "http://cs.indiana.edu:80/elisp/w3/docs.html"
  "*The url to open at startup. Probably want to set this in your .emacs")
(defvar w3-editing-annotation nil "Are we editing an annotation or not?")
(defvar w3-find-this-link nil "Link to go to within a document")
(defvar w3-global-history-file "~/.mosaic-global-history" "*Global history file")
(defvar w3-group-annotation-server "hoohoo.ncsa.uiuc.edu" "*Group ann server")
(defvar w3-group-annotation-port 8001 "*Port for group annotation server")
(defvar w3-hotlist nil "Default hotlist")
(defvar w3-hotlist-file "~/.mosaic-hotlist-default" "*Hotlist file")
(defvar w3-html2latex-args "-s -" "*Args to pass w3-html2latex-prog")
(defvar w3-html2latex-prog "html2latex" "*Program to convert html to latex")
(defvar w3-hypertext-extns '(".html" ".mime" ".jpg" ".gif" ".xbm"
			     ".xwd"  ".mpg"  ".au"  ".dvi" ".ps"
			     ".Z"    ".z"    ".tar" ".snd" ".h")
  "*File extensions that don't need a PLAINTEXT at the beginning when in
local file mode.")
(defvar w3-uncompressor-alist '((".z"  . "gunzip")
				(".gz" . "gunzip")
				(".Z"  . "uncompress"))
  "*An assoc list of file extensions and the appropriate uncompression
programs for each.")
(defvar w3-link-begin-regexp "<A[ \t\n]+[^>]*>\\\n*" "*The beginning of a url")
(defvar w3-link-end-regexp   "\\\n*</A>\\\n*" "*The end of a url")
(defvar w3-load-hooks nil "*Hooks to be run after loading w3")
(defvar w3-mode-hooks nil "*Hooks to be run after entering w3-mode")
(defvar w3-file-prepare-hooks nil "*Hooks to be run before preparing a buffer")
(defvar w3-file-done-hooks nil "*Hooks to be run after preparing a buffer")
(defvar w3-mode-map (make-keymap) "*Keymap to use in w3-mode")
(defvar w3-mutable-windows nil "*Popup new buffers in another window?")
(defvar w3-news-server (or (getenv "NNTPSERVER") "news") "*News server")
(defvar w3-personal-annotation-directory "~/.mosaic-personal-annotations"
  "*Directory where w3 looks for personal annotations")
(defvar w3-personal-annotations nil "Assoc list of personal annotations")
(defvar w3-pre-data nil "Data extracted from <PRE> regions")
(defvar w3-pre-data-count 0 "# of items from <PRE> regions")
(defvar w3-print-command "lpr -h -d" "*Print command for dvi files")
(defvar w3-print-next nil "Should we latex & print the next doc?")
(defvar w3-right-border 2 "*Amount of space to leave on right margin.")
(defvar w3-running-epoch (and (boundp 'epoch::version)
			      epoch::version) "*In Epoch")
(defvar w3-running-lemacs (string-match "Lucid" (emacs-version)) "*In lucid?")
(defvar w3-running-FSF19 (and (string-match "^19" emacs-version)
			      (not w3-running-lemacs)) "*In FSF v19 emacs?")
(defvar w3-telnet-ready-regexp "Escape character is .*" "End of telnet hdrs")
(defvar w3-telnet-header-length 1 "*How many lines to kill in a telnet buffer")
(defvar w3-telnet-prog "telnet" "*Program for opening telnet connections")
(defvar w3-use-telnet nil "*Use telnet or open-network-stream?")
(defvar w3-use-html2latex nil "*Use html2latex program, or regexp matching?")
(defvar w3-use-http2 t "*Use HTTP/1.0 Support or not?")
(defconst w3-version-number ".98b" "Version # of w3-mode")
(defconst w3-version (format "WWW %s September 5, 1993" w3-version-number)
  "More descriptive")
(defvar w3-xmp-data nil "Data extracted from <XMP> regions")
(defvar w3-xmp-data-count 0 "# of items from <XMP> regions")
(defvar w3-xterm-command "xterm" "*Command used to start an xterm window")
(defvar w3-keep-history nil "*Keep history of visited urls for xmosaic")
(defvar w3-history-list nil "List of urls visited this session")
(defvar w3-zones-list nil "*List of 'zones' in a dumb emacs buffer")
(defvar w3-graphics-list nil "*List of graphics already read in.")
(defconst w3-color-planes  (cond
			    (w3-running-lemacs (x-display-planes))
			    ((and w3-running-FSF19 (eq window-system 'x))
			     (x-display-planes))
			    (w3-running-epoch 8)
			    (t nil))
  "How many bits of color can this display show?")

(defconst w3-color-display (cond
			    (w3-running-lemacs (x-color-display-p))
			    ((and w3-running-FSF19 (eq window-system 'x))
			     (x-display-color-p))
			    (w3-running-epoch t)
			    (t nil))
  "Is this display color or not?")

(defvar w3-documents-menu nil
  "*Defines a documents menu.  It defines a menu if you are in emacs19
or lucid emacs.  Syntax is: ( (title  . url) ... )")  

(defvar w3-delimit-links (and (not w3-running-lemacs)
			      (not w3-running-epoch)
			      (not (and (eq window-system 'x)
					w3-running-FSF19)))
  "*Put brackets around links?  If this variable is eq to 'linkname, then
it will put the link # in brackets after the link text.  If it is nil, then
it will not put anything.  If it is non-nil and not eq to 'linkname, then
it will put [[ & ]] around the entire text of the link.  Is initially set
to be t iff in normal emacs.  Nil if in epoch or lucid emacs, since links
should be in different colors/fonts.")

(defvar w3-graphic-converter-alist
  '((".xbm"  . "xbmtopbm  | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; X bitmaps
    (".gif"  . "giftoppm  | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; Gifs
    (".fax"  . "g3topbm   | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; G3 Faxes
    (".h"    . "xbmtopbm  | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; X Bitmaps
    (".ras"  . "rasttoppm | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; Raster 
    (".xwd"  . "xwdtoppm  | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; wndowdumps
    (".icon" . "icontopbm | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; Xicons
    (".pgm"  . "pgmtoppm  | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; Graymaps
    (".pict" . "picttoppm | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; PICT Files
    (".macp" . "macptopbm | ppmtoxpm -rgb /usr/lib/X11/rgb.txt") ; MacPaint
    (".tga"  . "tgatoppm  | ppmtoxpm -rgb /usr/lib/X11/rgb.txt")); Targa
  "*How to convert graphics into xpixmaps")

(defvar w3-viewer-alist
  '(
    ("\\.ps$" . "ghostview %s")
    ("\\.\\(jpg\\|xbm\\|gif\\|ras\\|ppm\\)$" . "xv -perfect %s")
    ("\\.mpeg$" . "mpeg_play %s")
    ("\\.\\(au\\|snd\\)$" . "play %s")
    ("\\.dvi" . "xdvi %s")
    ("\\.tar" . tar-mode)
    ("\\.txt" . view-mode)
    )
  "*An assoc-list of viewers for specific file extensions.")

(defvar w3-doc-functions '(
			   w3
			   w3-add-document-to-hotlist
			   w3-add-gopher-hotlist-entry
			   w3-add-group-annotation
			   w3-add-personal-annotation
			   w3-back-link
			   w3-delete-group-annotation
			   w3-delete-personal-annotation
			   w3-document-source
			   w3-fetch
			   w3-follow-link
			   w3-forward-link
			   w3-goto-last-buffer
			   w3-help
			   w3-insert-this-url
			   w3-mail-current-document
			   w3-open-local
			   w3-popup-menu
			   w3-preview-this-buffer
			   w3-print-this-url
			   w3-print-url-under-point
			   w3-quit
			   w3-reload-document
			   w3-remove-from-hotlist
			   w3-search
			   w3-show-history-list
			   w3-submit-bug
			   w3-toggle-telnet
			   w3-use-hotlist
			   w3-view-this-url
			   w3-view-url
			   w3-write-global-history
			   )
  "*Functions to document automatically")

(defvar w3-doc-variables '(
			   w3-annotation-marker
			   w3-default-homepage
			   w3-delimit-links
			   w3-file-done-hooks
			   w3-file-prepare-hooks
			   w3-global-history-file
			   w3-graphic-converter-alist
			   w3-group-annotation-port
			   w3-group-annotation-server
			   w3-history-list
			   w3-hotlist-file
			   w3-html2latex-args
			   w3-html2latex-prog
			   w3-hypertext-extns
			   w3-keep-history
			   w3-link-end-delimiter
			   w3-link-start-delimiter			   
			   w3-mode-hooks
			   w3-mutable-windows
			   w3-news-server
			   w3-print-command
			   w3-running-epoch
			   w3-running-FSF19
			   w3-running-lemacs
			   w3-telnet-header-length
			   w3-telnet-prog
			   w3-uncompressor-alist
			   w3-use-html2latex
			   w3-use-telnet
			   w3-viewer-alist
			   w3-xterm-command)
  "*Variables to document automatically")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Startup items
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(make-variable-buffer-local 'w3-current-type)
(make-variable-buffer-local 'w3-current-annotation)
(make-variable-buffer-local 'w3-current-file)
(make-variable-buffer-local 'w3-current-server)
(make-variable-buffer-local 'w3-current-port)
(make-variable-buffer-local 'w3-current-isindex)
(make-variable-buffer-local 'w3-zones-list)
(make-variable-buffer-local 'w3-current-last-buffer)
(make-variable-buffer-local 'w3-current-mime-encoding)
(make-variable-buffer-local 'w3-current-mime-server-type)
(make-variable-buffer-local 'w3-current-mime-viewer)
(make-variable-buffer-local 'w3-current-mime-type)

(suppress-keymap w3-mode-map)
(define-key w3-mode-map "\r"       'w3-follow-link)
(define-key w3-mode-map "\C-?"     'scroll-down)
(define-key w3-mode-map "\C-o"     'w3-fetch)
(define-key w3-mode-map "\M-s"     'w3-document-source)
(define-key w3-mode-map "\M-\C-i"  'w3-insert-this-url)
(define-key w3-mode-map "m"	   'w3-mail-current-document)
(define-key w3-mode-map "\M-b"     'w3-goto-last-buffer)
(define-key w3-mode-map "h"	   'w3-use-hotlist)
(define-key w3-mode-map "a"	   'w3-add-document-to-hotlist)
(define-key w3-mode-map "d"        'w3-remove-from-hotlist)
(define-key w3-mode-map "f"	   'w3-forward-link)
(define-key w3-mode-map "\C-c\C-b" 'w3-show-history-list)
(define-key w3-mode-map "b"	   'w3-back-link)
(define-key w3-mode-map "H"        'w3-help)
(define-key w3-mode-map "s"        'w3-document-source)
(define-key w3-mode-map " "	   'scroll-up)
(define-key w3-mode-map "P"        'w3-print-this-url)
(define-key w3-mode-map "o"	   'w3-open-local)
(define-key w3-mode-map "\M-\C-v"  'w3-version)
(define-key w3-mode-map "v"	   'w3-view-url)
(define-key w3-mode-map "V"        'w3-view-this-url)
(define-key w3-mode-map "r"        'w3-reload-document)
(define-key w3-mode-map "s"	   'w3-search)
(define-key w3-mode-map "w"        'w3-submit-bug)
(define-key w3-mode-map "\C-q"     'w3-write-global-history)
(define-key w3-mode-map "q"	   'w3-quit)
(define-key w3-mode-map "\C-k"     'w3-save-url)

(provide 'w3-vars)
