;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Copyright (c) 1993 by William M. Perry (wmperry@indiana.edu)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(require 'w3)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Experimental functions for formatting nested lists in html
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun w3-build-table (indent-level)
  "Build a Definition List"
  (set-buffer " *W3*")
  (w3-replace-regexp "<DT>" "\n<DT>")
  (goto-char (point-min))
  (while (re-search-forward "<\\(DT\\|DD\\)>" nil t)
    (let* ((start (match-beginning 0))
	   (smallend (match-end 0))
	   (end (if (re-search-forward "<DD>" nil t) (point) nil))
	   (bigend (progn (end-of-line) (point)))
	   (dt (buffer-substring (+ 4 start) (if end (- end 4) bigend)))
	   (dd (if end (buffer-substring end bigend) "")))
      (if end
	  (progn
	    (goto-char (- end 4))
	    (delete-char 4)))
      (goto-char start)
      (if (>= smallend (point-max)) (setq smallend (1- (point-max))))
      (delete-region start smallend)
      (goto-char start)
      (insert (format "%s* " (make-string indent-level 9)))
      (re-search-forward (regexp-quote dt) nil t)
      (if (not (equal dt ""))
	  (if (equal "\n" (substring dt -1 nil)) (delete-backward-char 1)))
      (insert ":"
					;	      (if (not (equal "\n" (substring dt -1 nil))) "\n" "")
	      (make-string (1+ indent-level) 9))
      (goto-char start)))
  (goto-char (point-min))
  (w3-replace-regexp "</*DL>" "\n"))

(defun w3-build-ordered-list (indent-level)
  "Builds ordered lists"
  (set-buffer " *W3*")
  (goto-char (point-min))
  (let ((x 1))
    (goto-char (point-min))
    (while (re-search-forward "<LI>" nil t)
      (replace-match (format "\n%s%3d."
			     (make-string indent-level 9) x))
      (setq x (1+ x))))
  (goto-char (point-min))
  (w3-replace-regexp "</*OL>" "\n"))

(defun w3-build-unordered-list (indent-level)
  "Build unordered lists"
  (set-buffer " *W3*")
  (goto-char (point-min))
  (while (re-search-forward "<LI>" nil t)
    (replace-match (format "\n%s* " ;(if w3-running-FSF19 "\n" "")
			   (make-string indent-level 9))))
  (goto-char (point-min))
  (w3-replace-regexp "</*\\(UL\\|DIR\\|MENU\\)>" "\n"))

(defun w3-handle-lists (indent-level)
  "Handle building of lists - INDENT-LEVEL is how many tabs to use
to indent from the left margin."
  (let ((type (upcase (buffer-substring (match-beginning 1) (match-end 1))))
	(pos nil)
	(oldpos nil))
    (while (setq pos (w3-sublists-exist))
      (goto-char pos)
      (setq indent-level (1+ indent-level)
	    type (buffer-substring (match-beginning 1) (match-end 1))))
    (narrow-to-region (- (point) (+ 2 (length type)))
		      (progn
			(re-search-forward (format "</%s>" type) nil t)
			(point)))
    (cond
     ((equal "OL" type) (w3-build-ordered-list indent-level))
     ((equal "DL" type) (w3-build-table indent-level))
     (t (w3-build-unordered-list indent-level)))
    (widen)))

(defun w3-sublists-exist ()
  "Figure out if there are sublists in the current list.  Expects point to
be _AFTER_ the current list tag, and type to be bound to what sort of
list it is (OL, UL, DL, MENU, etc)"
  (save-excursion
    (let* ((thestart  (point))
	   (newend (progn
		     (re-search-forward (format "</%s>" type) nil t)
		     (point))))
      (goto-char thestart)
      (if (re-search-forward "<\\(DL\\|OL\\|UL\\|DIR\\|MENU\\)>" newend t)
	  (point)
	nil))))

(defun w3-do-lists ()
  (let ((tmp 0))
    (while (progn
	     (goto-char (point-min))
	     (re-search-forward "<\\(DL\\|OL\\|UL\\|DIR\\|MENU\\)>" nil t))
      (w3-handle-lists 1)
      (setq tmp (1+ tmp))
      (message "Building lists...%s" (make-string tmp ?.)))))

(provide 'w3-lists)
