@
% This file is part of CWEB.
% This program by Silvio Levy is based on a program by D. E. Knuth.
% It is distributed WITHOUT ANY WARRANTY, express or implied.
% (Revision: 2.0) % Don Knuth, July 1990

% $Id: common.h,v 2.6 1991/10/01 15:52:33 fj Exp $

% Copyright (C) 1987,1990 Silvio Levy and Donald E. Knuth

% Permission is granted to make and distribute verbatim copies of this
% document provided that the copyright notice and this permission notice
% are preserved on all copies.

% Permission is granted to copy and distribute modified versions of this
% document under the conditions for verbatim copying, provided that the
% entire resulting derived work is distributed under the terms of a
% permission notice identical to this one.

% Please send comments, suggestions, etc. to levy@@princeton.

% The next few sections contain stuff from the file |"common.w"| that has
% to be included in both |"tangle.w"| and |"weave.w"|. It appears in
% file |"common.h"|, which needs to be updated when |"common.w"| changes.


The next few sections contain stuff from the file |"common.w"| that has
to be included in both |"tangle.w"| and |"weave.w"|. It appears in
file |"common.h"|, which needs to be updated when |"common.w"| changes.

First comes general stuff:

@d tangle 0
@d weave 1

@d false (boolean) 0
@d true (boolean) 1

@<Common declarations for \.{CWEAVE} and \.{CTANGLE}@>=
typedef short boolean;
typedef unsigned char eight_bits;
extern int program; /* \.{WEAVE} or \.{TANGLE}? */
extern int phase; /* which phase are we in? */
extern boolean C_plus_plus; /* processing \Cpp? */

void common_init (), print_stats ();
void init_node ();
boolean names_match ();
void init_p ();

int tolower ();
int fflush (), fclose (), ungetc ();
int printf ();
int fprintf ();
int _flsbuf (), _filbuf ();


@ The following parameters were sufficient in the original \.{WEAVE} to
handle \TeX, so they should be sufficient for most applications of \.{CWEAVE}.
If you change |max_bytes|, |max_names|, |hash_size| or |buf_size|
you have to change them also in the file |"common.w"|.

@d max_bytes 90000 /* the number of bytes in identifiers,
  index entries, and module names */
@d max_names 4000 /* number of identifiers, strings, module names;
  must be less than 10240; used in |"common.w"| */
@d max_modules 2000 /* greater than the total number of modules */
@d hash_size 353 /* should be prime */
@d hash_end  (hash + hash_size - 1) /* end of |hash| */
@d buf_size 100 /* maximum length of input line, plus one */
@d longest_name 400 /* module names and strings shouldn't be longer than this */
@d long_buf_size 500 /* |buf_size+longest_name| */
@d line_length 80 /* lines of \TeX\ output have at most this many characters;
  should be less than 256 */
@d max_refs 20000 /* number of cross-references; must be less than 65536 */
@d max_toks 20000 /* number of symbols in \Cee\ texts being parsed;
  must be less than 65536 */
@d max_texts 2000 /* number of phrases in \Cee\ texts being parsed;
  must be less than 10240 */
@d max_scraps 1000 /* number of tokens in \Cee\ texts being parsed */
@d stack_size 400 /* number of simultaneous output levels */


@
@<Include files@>=
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>

@ Code related to the character set:

@d mod_text_end  (mod_text + longest_name) /* end of |mod_text| */

@<Common declarations...@>=
extern char mod_text[]; /* name being sought for */
extern char *id_first; /* where the current identifier begins in the buffer */
extern char *id_loc; /* just after the current identifier in the buffer */

@ Code related to input routines:

@<Common declarations...@>=
extern char buffer[]; /* where each line of input goes */
extern char *loc; /* points to the next character to be read from the buffer*/
extern char *limit; /* points to the last character in the buffer */

@ Code related to identifier and module name storage:
@d name_begin(p) ((p)->byte_start)
@d name_end(p) ((p+1)->byte_start)
@d length(p) (name_end (p) - name_begin (p)) /* the length of a name */
@d print_id(p) term_write (name_begin (p), length (p))
  /* print identifier or module name */
@d llink link /* left link in binary search tree for module names */
@d rlink dummy.Rlink /* right link in binary search tree for module names */
@d root name_dir->rlink /* the root of the binary search tree
  for module names */

@<Common declarations...@>=
typedef struct name_info {
  char *byte_start; /* beginning of the name in |byte_mem| */
  struct name_info *link;
  union {
    struct name_info *Rlink; /* right link in binary search tree for module
      names */  
    int Ilk; /* used by identifiers in \.{WEAVE} only */
  } dummy;
  void *equiv_or_xref; /* info corresponding to names */
} name_info; /* contains information about an identifier or module name */
typedef name_info *name_pointer; /* pointer into array of |name_info|s */
typedef name_pointer *hash_pointer;
extern char byte_mem[]; /* characters of names */
extern name_info name_dir[]; /* information about names */
extern name_pointer name_ptr; /* first unused position in |byte_start| */
extern char *byte_ptr; /* first unused position in |byte_mem| */
extern name_pointer hash[]; /* heads of hash lists */
extern name_pointer id_lookup(); /* looks up a string in the identifier table */
extern name_pointer mod_lookup(); /* finds module name */
extern name_pointer prefix_lookup(); /* finds module name given a prefix */

@ Code related to error handling:
@d spotless 0 /* |history| value for normal jobs */
@d harmless_message 1 /* |history| value when non-serious info was printed */
@d error_message 2 /* |history| value when an error was noted */
@d fatal_message 3 /* |history| value when we had to stop prematurely */
@d mark_harmless {if (history==spotless) history=harmless_message;}
@d mark_error history=error_message
@d confusion(s) fatal("! This can't happen: ",s)
@d fatal(s,t) {
  printf(s); err_print(t);
  history=fatal_message; wrap_up();
}
@d overflow(t) {
  printf("\n! Sorry, %s capacity exceeded",t); fatal("","");
}

@<Common declarations...@>=
extern history; /* indicates how bad this run was */
extern void err_print (); /* prints error message and context */
extern void wrap_up (); /* indicate |history| and exit */

@ Code related to file handling:
@f line x /* make |line| an unreserved word */
@d max_file_name_length 60
@d cur_file file[include_depth] /* current file */
@d cur_file_name file_name[include_depth] /* current file name */
@d web_file_name file_name[0] /* main source file name */
@d cur_line line[include_depth] /* number of current line in current file */

@<Common declarations...@>=
extern include_depth; /* current level of nesting */
extern FILE *file[]; /* stack of non-change files */
extern FILE *change_file; /* change file */
extern char C_file_name[]; /* name of |C_file| */
extern char tex_file_name[]; /* name of |tex_file| */
extern char file_name[][max_file_name_length];
  /* stack of non-change file names */
extern char change_file_name[]; /* name of change file */
extern line[]; /* number of current line in the stacked files */
extern change_line; /* number of current line in change file */
extern boolean input_has_ended; /* if there is no more input */
extern boolean changing; /* if the current line is from |change_file| */
extern boolean web_file_open; /* if the web file is being read */
extern void reset_input (); /* initialize to read the web file and change file */
extern boolean get_line (); /* inputs the next line */
extern void check_complete (); /* checks that all changes were picked up */

@ Code related to module numbers:
@<Common declarations...@>=
typedef unsigned short sixteen_bits;
extern module_count; /* the current module number */
extern boolean changed_module[]; /* is the module changed? */
extern boolean print_where; /* tells \.{TANGLE} to print line and file info */

@ Code related to command line arguments:
@d show_banner flags['b'] /* should the banner line be printed? */
@d show_progress flags['p'] /* should progress reports be printed? */
@d show_happiness flags['h'] /* should lack of errors be announced? */

@<Common declarations...@>=
extern int argc; /* copy of |ac| parameter to |main| */
extern char **argv; /* copy of |av| parameter to |main| */
extern boolean flags[]; /* an option for each character code */

@ Code relating to output:
@d update_terminal fflush (stdout) /* empty the terminal output buffer */
@d new_line putchar ('\n')
@d putxchar putchar
@d term_write(a,b) printf ("%.*s", b, a) /* write on the standard output */
@d C_printf(c,a) fprintf (C_file, c, a)
@d C_putc(c) putc (c, C_file) /* isn't \Cee\ wonderfully consistent? */

@<Common declarations...@>=
extern FILE *C_file; /* where output of \.{TANGLE} goes */
extern FILE *tex_file; /* where output of \.{WEAVE} goes */
void print_progress (), print_module_progress ();
