######################### -*- Mode: Perl -*- #########################
##
## File          : $Basename: Makefile.PL $
##
## Author        : Norbert Gvert
## Created On    : Mon Nov 27 12:16:52 2000
## Last Modified : Time-stamp: <2000-11-29 09:59:38 goevert>
##
## Description   : generates Makefile for Muscat::Stem
##
## $Id: Makefile.PL 1.3 Wed, 29 Nov 2000 10:00:08 +0100 goevert $
## $ProjectHeader: Muscat-Stem 0.3 Wed, 29 Nov 2000 10:00:08 +0100 goevert $
##
######################################################################


use strict;

use ExtUtils::MakeMaker;
use File::Basename;


my @exe_files = grep { $_ !~ /~$/ } glob('script/*');

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile
  ( EXE_FILES      => [ @exe_files ],
    MYEXTLIB       => 'C/libstem$(LIB_EXT)',
    NAME           => 'Muscat::Stem',
    PMLIBDIRS      => [ qw(lib) ],
    VERSION_FROM   => 'lib/Muscat/Stem.pm', # finds $VERSION
  );


## ###################################################################
## subs
## ###################################################################

sub MY::postamble {
'
$(MYEXTLIB): C/Makefile
	cd C && $(MAKE) $(PASTHRU)

ftpdist: dist
	rm -f /home-local/ftp/pub/src/Perl/$(DISTNAME)-*.tar$(SUFFIX)
	mv $(DISTVNAME).tar$(SUFFIX) /home-local/ftp/pub/src/Perl
'
  ;
}


__END__
## ###################################################################
## pod
## ###################################################################

=head1 NAME

Makefile.PL - generates Makefile for Muscat::Stem(3)

=head1 SEE ALSO

Muscat::Stem(3),
perl(1),
h2xs(1),
ls6h2xs(1),
ExtUtils::MakeMaker(3).

=head1 AUTHOR

Norbert GE<ouml>vert E<lt>F<goevert@ls6.cs.uni-dortmund.de>E<gt>

=cut
