######################### -*- Mode: Perl -*- #########################
##
## File          : $Basename: Makefile.PL $
##
## Author        : Norbert Goevert
## Created On    : Wed Nov 11 15:56:08 1998
## Last Modified : Time-stamp: <2000-11-29 09:56:51 goevert>
##
## Description   : generates Makefile for LSP
##
## $Id: Makefile.PL 1.4 Wed, 29 Nov 2000 09:57:57 +0100 goevert $
## $ProjectHeader: LSP 2.6 Wed, 29 Nov 2000 09:57:57 +0100 goevert $
##
######################################################################


require 5.6.0;


use strict;

use ExtUtils::MakeMaker;
use File::Basename;


my @exe_files = grep { $_ !~ /~$/ } glob('script/*');

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile
  ( EXE_FILES    => [ @exe_files ],
    NAME         => 'LSP',
    PREREQ_PM    => { 'Math::Matrix' => 0.08,
                      'Storable'     => 0.6
                    },
    VERSION_FROM => 'lib/LSP.pm', # finds $VERSION
    clean        => { FILES => '*/*/*/*~' },
  );


## ###################################################################
## subs
## ###################################################################

sub MY::postamble {
'
ftpdist: dist
	rm -f /home-local/ftp/pub/src/Perl/$(DISTNAME)-*.tar$(SUFFIX)
	mv $(DISTVNAME).tar$(SUFFIX) /home-local/ftp/pub/src/Perl
'
  ;
}


__END__
## ###################################################################
## pod
## ###################################################################

=head1 NAME

Makefile.PL - generates Makefile for LSP(3)

=head1 SEE ALSO

LSP(3),
perl(1),
h2xs(1),
ls6h2xs(1),
ExtUtils::MakeMaker(3).

=head1 AUTHOR

Norbert GE<ouml>vert E<lt>F<goevert@ls6.cs.uni-dortmund.de>E<gt>

=cut
