#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the University
 * of Illinois Board of Trustees.  No warranties expressed or implied, no
 * support provided.  Please do not redistribute it in its present form.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * do_lookup takes an array of pointers to strings and an array of unsigned
 * long and returns an array of long which represent indicies into
 * the directory of entries that contain all the strings given and is a
 * subset of the array given. No array (empty) means return all matches.
 *
 * It always returns an array.
 */

#define ARY_FREE(a)	if(a){free((char*)a);a=NULL;}

long *
do_lookup(strings, ary)
	char **strings;
	long *ary;
{
	long	*new_ary, *old_ary;

	while (*strings)
	{
#ifdef LIMIT_SEARCH
		if (all_metas(*strings))
		{		/*ignore all words with all metas */
			*strings++ = (char *) NIL;
			continue;
		}
#endif /*LIMIT_SEARCH*/

		if (!quoted(*strings) && anyof(*strings, METAS))
			new_ary = find_all(*strings++);
		else
			new_ary = findstr(*strings++);


		if (!new_ary)
		{		/*no entry for this string */
			if (!ary)
				ary = (long *) malloc(WORDSIZE);
			ary[0] = 0;
			break;
		}
		if (!ary)
		{		/*first time through, with no array given */
			ary = new_ary;
			continue;
		}
		ary = intersect(old_ary = ary, new_ary);

		ARY_FREE(new_ary);
		ARY_FREE(old_ary);

		if (length(ary) == 0)	/*no matches */
			break;
	}
	return (ary);
}

/*
 * make_lookup puts all of the words in "str" into the index with a pointer
 * to the directory entry "ent"
 */

void 
make_lookup(str, ent)
	char *str;
	int ent;
{
	char	buf[MAX_LEN];
	char	*cp;

	(void) strcpy(buf, str);
	for (cp = strtok(buf, IDX_DELIM); cp; cp = strtok(0, IDX_DELIM))
	{
		if (!putstr(cp, ent))
			IssueMessage(LOG_WARNING, "putstr failed (%s:%d).", cp, ent);
	}
}

/*
 * remove pointers to entries from the index for words in str
 */
void 
unmake_lookup(str, ent)
	char *str;
	int ent;
{
	char	buf[MAX_LEN];
	char	*cp;

	(void) strcpy(buf, str);
	for (cp = strtok(buf, IDX_DELIM); cp; cp = strtok(0, IDX_DELIM))
	{
		if (strlen(cp) > 1)
			if (deletestr(cp, ent) == 0)
				IssueMessage(LOG_WARNING, "unmake_lookup deletestr failed.");
	}
}

/*
 * make or unmake index entries for a directory entry
 */
MakeLookup(dirp, entry, func)
	QDIR	dirp;
	long	entry;
	int	(*func) ();

{
	FDESC	*fd;
	char	*value;
	char	*atSign;

	for (; *dirp; dirp++)
	{
		value = (*dirp);	/*value preceeded by number */
		fd = FindFDI(atoi(value));
		if (!fd)
			IssueMessage(LOG_DEBUG, "Unknown database field %d.\n", atoi(value));
		else
		{
			if (fd->fdIndexed)
			{
				if ((value = index(value, ':')))	/*strip number */
				{
					value++;
					switch (fd->fdId)
					{
					case F_EMAIL:
						(*func) (value, entry);
						if (atSign = index(value, '@'))
						{
							*atSign = 0;
							(*func) (value, entry);
							*atSign = '@';
						}
						break;
					default:
						(*func) (value, entry);
						break;
					}
				}
			}
		}
	}
}
