/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

#include <stdio.h>
#include <cdefs.h>
#include "bintree.h"

extern QHEADER header;
extern IDX last_node;
extern NODE *node_buf;
extern LEAF_DES *leaf_des_buf;
extern int seq_fd;
static char *max_key __P((LEAF *));


IDX
allocate_node()
{
	if (!last_node)
		node_buf = (NODE *) malloc((unsigned) (header.last_leaf + 1) * 2 * NODE_SIZE);
	return (++last_node);
}

IDX
build_tree(first_des, last_des)
	IDX	first_des;
	IDX	last_des;
{
	IDX	root;
	IDX	mid_des;

	root = allocate_node();
	switch (last_des - first_des)
	{
	case 0:
		strncpy(node_buf[root].key, leaf_des_buf[first_des].max_key,
			KEY_SIZE);
		node_buf[root].l_ptr = -leaf_des_buf[first_des].leaf_no;
		node_buf[root].r_ptr = -leaf_des_buf[first_des].leaf_no;
		free(malloc(100));
		return (root);
	case 1:
		strncpy(node_buf[root].key, leaf_des_buf[first_des].max_key,
			KEY_SIZE);
		node_buf[root].l_ptr = -leaf_des_buf[first_des].leaf_no;
		node_buf[root].r_ptr = -leaf_des_buf[last_des].leaf_no;
		free(malloc(100));
		return (root);
	default:
		mid_des = (first_des + last_des) / 2;
		strncpy(node_buf[root].key, leaf_des_buf[mid_des].max_key,
			KEY_SIZE);
		node_buf[root].l_ptr = build_tree(first_des, mid_des);
		node_buf[root].r_ptr = build_tree(mid_des + 1, last_des);
		free(malloc(100));
		return (root);
	}
}

build_leaf_descriptors()
{
	IDX	leaf_index;
	LEAF	leaf;
	int	max_des;

	leaf_des_buf =
	    (LEAF_DES *) malloc((unsigned) sizeof (LEAF_DES) * (header.last_leaf + 1));
	max_des = 0;
	for (leaf_index = header.seq_set; leaf_index; leaf_index = leaf.next)
	{
		max_des++;
		read_leaf(leaf_index, &leaf);
		leaf_des_buf[max_des].leaf_no = leaf.leaf_no;
		strncpy(leaf_des_buf[max_des].max_key, max_key(&leaf), KEY_SIZE);
	}
	free(malloc(100));
	return max_des;
}

static char *
max_key(leaf)
	LEAF *leaf;
{
	int	i;
	static ITEM item;

	for (i = 0; i < leaf -> n_bytes; i += icopy(item.raw, &leaf -> data[i]))
		;
	if (strlen(item.i_key) > 4)
		item.i_key[3]++;
	item.i_key[4] = '\0';
	return item.i_key;
}

write_index(filename)
	char	*filename;
{
	FILE	*fp;
	int	n_items;

	free(malloc(100));
	if (close(creat(filename, 0600)) < 0)
	{
		printf("create() failed in write_index()\n");
		exit(1);
	}
	if ((fp = fopen(filename, "w")) == NULL)
	{
		printf("fopen() failed in write_index()\n");
		exit(1);
	}
	n_items = fwrite((char *) node_buf, NODE_SIZE, last_node + 1, fp);
	if (n_items != last_node + 1)
	{
		printf("fwrite() failed in write_index()\n");
		exit(1);
	}
	printf("%d items (%d bytes each) written on file %s\n",
	       n_items, NODE_SIZE, filename);

}

/*
 * * Create a new sequence set file and intiialize its header.
 */
new_file(filename)
	char	*filename;
{
	LEAF	leaf;

	if (close(creat(filename, 0660)) < 0)
	{
		perror("Creat() failed in new_file()");
		exit(1);
	}
	if ((seq_fd = open(filename, 2)) < 0)
	{
		perror("Open() failed in new_file()");
		exit(1);
	}
	leaf.leaf_no = allocate_leaf();
	leaf.next = 0;
	leaf.n_bytes = 0;

	header.seq_set = leaf.leaf_no;
	header.freelist = 0;
	header.last_leaf = leaf.leaf_no;
	header.index_root = 0;
	header.reads = 0;
	header.writes = 0;
	header.lookups = 0;
	header.inserts = 0;
	header.deletes = 0;

	if (write(seq_fd, (char *) &header, HEADSIZE) < HEADSIZE)
	{
		printf("write() of header failed in new_file()\n");
		exit(1);
	}
	if (lseek(seq_fd, (long) (HEADBLKS * LBSIZE - 1), 0) < 0)
	{
		printf("lseek() failed in new_file()\n");
		exit(1);
	}
	if (write(seq_fd, "", 1) < 0)
	{
		printf("write() of null byte failed in new_file()\n");
		exit(1);
	}
	write_leaf(&leaf);

}
