/* about.c -- goop to do the fancy "About xph" dealie.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Mon Apr 27 17:00:01 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>

#include "bcs.xpm2"
#include "global.h"

/* Declare some variables global to this module, for convenience, and
 * to make debugging interesting.  ;-)
 */
static Widget about_popup=NULL;
static void dismiss_about();
static Pixmap pixmap;
static unsigned long *pixels;
static unsigned long npixels;

static char brag[] =
"Xph 2.4 beta\n\n\
Written by:\n\
Bradley C. Spatz\n\
University of Florida\n\
bcs@ufl.edu";


#define TEXT_WIDTH 250
#define PM_WIDTH 108


void about_xph(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget	aform, acore, atext, adismiss;
    Position	x, y;
    Dimension	width, height;
    Display     *disp;
    int         scr;
    Visual      *vis;
    unsigned int pwidth, pheight;

    /* We think we're coming from a real widget, but actually from a
     * transient menu popup that's going away...snag a reference to its
     * static grandparent.
     */
    widget = XtParent(XtParent(widget));
    
    /* Only create this testament to vanity once. */
    if (about_popup == NULL) {
       about_popup = XtVaCreatePopupShell("about_xph",
					  transientShellWidgetClass, widget,
					  XtNtitle, "About Xph",
					  XtNiconPixmap, icon_pixmap, NULL);

       aform = XtCreateManagedWidget("aform", formWidgetClass, about_popup,
				     NULL, ZERO);

       /* Now create a pixmap and make it the background of the core. */
       disp = XtDisplay(about_popup);
       scr = DefaultScreen(disp);
       vis = DefaultVisual(disp, scr);
       XCreatePixmapFromData(disp, vis, DefaultRootWindow(disp),
			     DefaultColormap(disp, scr), bcs,
			     DefaultDepth(disp, scr), &pixmap,
			     &pwidth, &pheight, &pixels, &npixels,
			     NULL, ZERO, NULL);
       acore = XtVaCreateManagedWidget("acore", coreWidgetClass, aform,
				       XtNbackgroundPixmap, pixmap,
				       XtNwidth, pwidth, XtNheight, pheight,
				       NULL);
       atext = XtVaCreateManagedWidget("atext", asciiTextWidgetClass, aform,
				       XtNdisplayCaret, FALSE,
				       XtNwidth, TEXT_WIDTH,
				       XtNheight, pheight,
				       XtNstring, brag, NULL);
       adismiss = XtCreateManagedWidget("adismiss", commandWidgetClass, aform,
					NULL, ZERO);
       XtAddCallback(adismiss, XtNcallback, pop_down_widget,
		     (XtPointer) aform);
    }

    /* Position the widget so that we end up in the output window,
     * where we like it.  ;-)
     */
    XtVaGetValues(widget, XtNwidth, &width, XtNheight, &height, NULL);
    XtTranslateCoords(widget, (Position) (width / 2),
		      (Position) (height / 2), &x, &y);
    XtVaSetValues(about_popup, XtNx, x-TEXT_WIDTH-PM_WIDTH, XtNy, y, NULL);
    
    XtPopup(about_popup, XtGrabExclusive);

    /* Finally, find out the width and height of the window and set the
     * max values to this, thus disallowing any resizing.  My face is
     * already perfectly proportioned...
     */
    XtVaGetValues(about_popup, XtNwidth, &width, XtNheight, &height,
		  NULL);
    XtVaSetValues(about_popup, XtNmaxWidth, width, XtNminWidth, width,
		  XtNmaxHeight, height, XtNminHeight, height, NULL);
}


static void
dismiss_about(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
#if 0
   Display *disp;
   int scr;
   Widget parent;

   disp = XtDisplay((Widget) client_data);
   scr = DefaultScreen(disp);
   XFreeColors(disp, DefaultColormap(disp, scr), pixels, npixels, (long) ZERO);
   XFreePixmap(disp, pixmap);
   XtDestroyWidget(XtParent((Widget) client_data));
#else
   XtPopdown(about_popup);
#endif
}
