/*---------------------------------------------------------------------------
BoxViewSwitcher.h -- switch between box views using a popup list (button)

Copyright (c) 1990 Doug Brenner

$Source: /dbrenner/src/Class/BoxViewSwitcher.h,v $ $Revision: 2.0 $
---------------------------------------------------------------------------*/

#import <objc/Object.h>

@interface BoxViewSwitcher:Object
{                               /* ---------- outlets */
   id controlButton;		/* button that "pops up" the popup list */
   id boxViewWindow;		/* window with alternative box views */
   id boxView;			/* starting box view that is replaced */

   id delegate;			/* object to receive notification messages */

   id popup;			/* popup list activated by controlButton */
   id boxViewList;		/* list of all possible box views */
}

/* ---------- Setting values */

- setControlButton: anObject;
- setBoxViewWindow: anObject;
- setBoxView: anObject;
- setDelegate: anObject;

/* ---------- Returning values */

- controlButton;
- boxView;
- popup;
- boxViewList;

/* ---------- Interacting with the outside world */

- removeBoxTitles: sender;
- selectBoxView: sender;
- selectBoxViewTitle:(const char *) title;

/* ---------- Free */

- free;

/* ---------- Archiving */

- write:(NXTypedStream *) stream;
- read: (NXTypedStream *) stream;

/* ---------- Internal methods */

- setup;
- replaceBoxViewWith: aView;
+ initialize;

@end

@interface BoxViewSwitcherDelegates:Object {}

/* ---------- Implemented by the BoxViewSwitcher's delegate */

- boxViewDidSwitch:sender;

@end
