/* Copyright (c) 1992 Vincent Cate
 * All Rights Reserved.
 *
 * Permission to use and modify this software and its documentation
 * is hereby granted, provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative works
 * or modified versions, and any portions thereof, and that both notices
 * appear in supporting documentation.  This software or any derivate works
 * may not be sold or distributed without prior written approval from
 * Vincent Cate.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND VINCENT CATE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * VINCENT CATE BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Users of this software agree to return to Vincent Cate any improvements
 * or extensions that they make and grant Vincent Cate the rights to
 * redistribute these changes.
 *
 */



#include "alexincs.h"
#include "alex.h"

#define MAXOKDIFF  10*60

#define ANY_PROTOCOL ((char *) 0)

int GlobalSockNum = -1;

int AbortGetBufFromServer()
{
    LogN("AbortGetBufFromServer ", GlobalSockNum);
    if (GlobalSockNum > 2) {
        LogN("AbortGetBufFromServer closing ", GlobalSockNum);
        (void) close(GlobalSockNum);
    }
    return(0);
}


int GetBufFromServer(hostname, servername, buffer, buffersize)
char *hostname, *servername;
unsigned char buffer[];
int buffersize;
{
    int sock;
    int readsize;
    int Result;

    struct servent *service;
    struct hostent *host;
    struct sockaddr_in address;

    GlobalSockNum = -1;

    if (!(service = getservbyname(servername, ANY_PROTOCOL))) {
        Log("GetBufFromServer ERROR  unknown service");
        return(AFAIL);
    }

    if (!(host = gethostbyname(hostname))) {
        Log2("GetBufFromServer: ERROR unknown host", hostname);
        return(AFAIL);
    }

    Log2("GetBufFromServer  have a good hostname ", hostname);

    bzero((char *) &address, sizeof(address));
    address.sin_family = host->h_addrtype;
    address.sin_port = service->s_port;
    bcopy((char *) host->h_addr,(char *) &address.sin_addr, host->h_length);

    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
        error1("GetBufFromServer ERROR socket");
        return(AFAIL);
    }
    GlobalSockNum = sock;

    if (connect(sock, &address, sizeof (address))) {
        error1("GetBufFromServer ERROR connect");
        return(AFAIL);
    }

    Log2("GetBufFromServer  have a socket and a connection", hostname);


    (void) signal(SIGALRM, AbortGetBufFromServer);
    (void) alarm(200);

    if ((readsize = read(sock, (char *) buffer, buffersize)) < 0) {
        error1("GetBufFromServer ERROR read");
        Result=AFAIL;
    } else {
        buffer[readsize]=0;
        Result=AOK;
    }

    if (close(sock) != 0) {
        Log("GetBufFromServer ERROR could not close socket");
                                              /* lets just be optimistic and say AOK */
    }

    (void) signal(SIGALRM, AlarmIgnore);
    (void) alarm(0);

    return(Result);
}


double FourBytesToUnixDate(s)
unsigned char *s;
{
    unsigned int timeinsecs;
    unsigned long tmptime;

    tmptime =s[0];
    tmptime =(tmptime<<8) + s[1];
    tmptime =(tmptime<<8) + s[2];
    tmptime =(tmptime<<8) + s[3];
    tmptime -= 2208988800l;            /* to unix  - to big for a signed int */

    timeinsecs = tmptime;
    return(timeinsecs);
}



#define BUFFERSIZE 200



extern int HisClockIsOK(hostname)
char *hostname;
{
    unsigned char buffer[BUFFERSIZE];
    double RemTimeInSeconds, LocalTimeInSeconds;
    int Status, SecsDiff;

    Status=GetBufFromServer(hostname, "time", buffer, BUFFERSIZE);

    Log2("HisClockIsOK  GetBufFromServer returned ", ATypeToString(Status));
    if (Status != AOK) {
        return(-1);
    }

    RemTimeInSeconds=FourBytesToUnixDate(buffer);
    LogN("HisClockIsOK  Remote Time is ", (int) RemTimeInSeconds);

    LocalTimeInSeconds=TimeInSeconds();
    LogN("HisClockIsOK  Local Time is ",  (int) LocalTimeInSeconds);

    SecsDiff=(int) (RemTimeInSeconds - LocalTimeInSeconds);
    LogN("HisClockIsOK  Clocks differ by ", SecsDiff);

    if (abs(SecsDiff) > MAXOKDIFF) {
        LogN("HisClockIsOK  ERROR Clocks too different try again latter ", SecsDiff);
        return(0);
    } else {
        return(1);
    }
}


/*  Returns timezone as minutes west of Greenwich.
 *
 *  Returns RemTimeZoneFAIL for failure (unreasonable minutes)
 */
extern int RemTimeZone(hostname)
char *hostname;
{
    unsigned char buffer[BUFFERSIZE];
    int Status, Result;
    struct timeb Now, RemTimeB;
 
    
    Log2("RemTimeZone  ", hostname);

    Status=GetBufFromServer(hostname, "daytime", buffer, BUFFERSIZE);
    if (Status != AOK) {
        return(RemTimeZoneFAIL);
    }

    (void) ChopAtCR((char *)buffer);
    Log2("RemTimeZone  Remote Date is ", (char *) buffer);

    ftime(&Now);
    Status=StringToTimeb((char *) buffer, &Now, &RemTimeB);

    if (Status != AOK) {
        return(Status);
    }

    if (abs( (int) (Now.time - RemTimeB.time)) < MAXOKDIFF) {
        Result=RemTimeB.timezone; 
        Log("RemTimeZone is using zone StringToTimeb returned");
    } else {
        if (HisClockIsOK(hostname)) {
            Result  = RemTimeB.timezone;                     /* start with what parser used */
            Result += (Now.time - RemTimeB.time)/60;         /* correct for error           */
            Result  = 30 * rint(Result/30.0);                /* round to nearest 30 minutes */
            Log("RemTimeZone has corrected zone");
        } else {
            Result  = RemTimeZoneFAIL;
            Log("RemTimeZone ERROR could not get zone info");
        }
    }

    LogN("RemTimeZone  TimeZone difference in minutes is ", (int) (Result-Now.timezone));

    if (abs(Result) > 25*60) {
        LogN("RemTimeZone  ERROR ", Result);
        Result=RemTimeZoneFAIL;
    }
 
    LogN("RemTimeZone  about to return", Result);
    return(Result);
}



