
#include "alexincs.h"
#include "alex.h"

FILE *debugLog;

fh_fdclose()
{
    printf("ERROR fh_fdclose should not be called\n");
    exit(-1);
}

main(argc, argv)
int argc;
char *argv[];
{
    FILE *devnull;
    char myname[MAXPATH];

    PathToFileName(argv[0], myname);
    if ((argc > 2) || ((argc==1) && (!streql(myname, "cachedir")))) {
        fprintf(stderr, "%s: usage is %s [alexsrvr/home/install/resolver]\n", argv[0], argv[0]);
        exit(-1);
    }


    devnull=fopen("/dev/null", "w");
    if (devnull == NULL) {
       fprintf(stderr, "ERROR: Can not open /dev/null \n ");
       exit(-1);
    }

    debugLog=devnull;

    if (streql(myname, "cachedir") || streql(argv[1], "cachedir")) {
        InitReadOnlyVariables();           
        printf("%s\n", CACHEDIRVAR);          /* only one that needs Init */

    } else if (streql(argv[1], "alexsrvr")) {
        printf("%s\n", ALEXSRVR);

    } else if (streql(argv[1], "tmpdir")) {
        printf("%s\n", TMPDIR);
    
    } else if (streql(argv[1], "logdir")) {
        printf("%s\n", LOGDIR);
    
    } else if (streql(argv[1], "home")) {
        printf("%s\n", ALEXSRVRHOME);
    
    } else if (streql(argv[1], "debuglevel")) {
        printf("%d\n", DEBUGLEVEL);
    
    } else if (streql(argv[1], "install")) {
        printf("%s\n", INSTALLDIR);
    
    } else if (streql(argv[1], "cacheinfohead")) {
        printf("%s\n", CACHEINFOHEAD);
    
    } else if (streql(argv[1], "resolver")) {
#ifdef USINGRESOLVER
        printf("-lresolv\n");
#else
        printf("");
#endif
    }
}

