

/*
 *  Hopefully you can just run "make".  Failing that maybe you edit the first
 *  part of the Makefile a bit.  Failing that, you might edit something in
 *  this file, "config.h".  If you are on a new system type, the system
 *  includes are all in alexincs.h and you will probably have to edit that.
 *  It should really stop there though.  If you need to edit alexincs.h or
 *  other files please let me know what you had to do and what type of 
 *  machine/OS you are using.    Vince Cate  vac@cs.cmu.edu
 */

#ifdef CMU
#define DEBUGLEVEL    6
#define LOCALUSERDOMAIN  "cs.cmu.edu"             
#else
#define DEBUGLEVEL    3
#define LOCALUSERDOMAIN  "optional.domainname" /* where we know user IDs */
#endif

/* #define DFEWFFLUSH       / *   only flush log after errors (runs faster) */

#define COMPRESSPATH  "/usr/ucb/compress"    /* /bin/rm compresses better */
#define UNCOMPRESS    "/usr/ucb/uncompress"  /* should be real            */


#define MINFREEKB     4000          /* always try to keep a min of 4 MB free */


/* Mount point for the Alex server (used in host aliasing) */
#define ALEXPATH	"/alex"

/* To change the user ID do a global find/replace for "alexsrvr" in this file */
#define ALEXSRVR      "alexsrvr"
#define CACHEDIR      "/usr/alexsrvr/alex-cache" /* must end in "alex-cache"  */
#define LOGDIR        "/usr/alexsrvr/logs"
#define RUNNINGDIR    "/usr/alexsrvr"
#define ALEXSRVRHOME  "/usr/alexsrvr"
#define INSTALLDIR    "/usr/alexsrvr/bin"


#define TMPDIR        "/usr/alexsrvr/tmp"        /* this can be a symlink */

/* The directory "lib" and all these files in it must be owned by alexsrvr */
#define HOSTSLIST     "/usr/alexsrvr/lib/HostsList"
#define INODENEXT     "/usr/alexsrvr/lib/InodeNext"
#define ROOTALEXINFO  "/usr/alexsrvr/lib/RootAlexInfo"
#define CACHEINFOHEAD "/usr/alexsrvr/lib/cacheinfo.head"

#ifdef CMU
#define UIDSTR        "/usr/alexsrvr/lib/UidStr"  
                             /* do "make UidStr" to use this */
#else
#define UIDSTR        ""     /* works fine users with accounts on server */
#endif                       /* and ok for others                        */

                             /* !defined(CMU) */
#if !defined(hpux) && !defined(ultrix) && !defined(NeXT)
#define USINGRESOLVER   /* if using -lresolv in Makefile                   */
#endif

#define PHONEHOMEPATH "/usr/alexsrvr/lib/PhoneHome"  /* used to limit mail *

/****************************************************************************/
/***********    pobably don't need to change the rest  **********************/
/****************************************************************************/

/* Can uncomment the next line to get alex to try FTPing a compressed file
 * first.  This works with some new servers.  The problem is that normally
 * Alex lets you start looking at a large file while it is still being FTPed.
 * With the following you will have to wait for the whole transfer to be
 * able to look at the first screenful.  */
/* #define FTP_TRY_COMPRESS */


/* Alex should be run under its own user ID.  I would use "alex" but that was 
 * taken so at CMU I am using "alexsrvr" and it will be easiest if you use
 * "alexsrvr" as well.  The reason for doing this is that if things go wrong 
 * it would only be able to hurt files owned by it. 
 */
#define ALEXUID   -1 /* "alexsrvr" UID/GID for alexd to run as after it gets */
#define ALEXGID   -1 /* a secure port.  If -1 then uses getpwnam(ALEXSRVR)   */

/* By default alex uses ftpchild.c to do the FTPs.  If this works, do not
   change the following.  However, there are other options.  The next is to
   use PROXY_FTP_HOST which connects to an FTP server that is used as a
   gateway to the rest of the internet.  This works for ftp gatewasy where
   you say anonymous@remote.internet.host (i.e. hide the remote machine name
   in the password). 
 */

/*#define PROXY_FTP_HOST */   /* add name of FTP gateway here               */
 
/* #define NAMECHANGE  */ /* can be used on some systems to chance name of  */
                          /* ftpchild after forking so ps shows as an ftp   */

#define OKINCONSISTENCY 10 /* won't check if already have within Age/OKINCON */
                         
/* Note that in mountalex there is a retry time on the mount command
 * If the server is overloaded, it could be increased.     
 */

#define ALEXEXPORTSFILE "/usr/alexsrvr/etc/unfsd_exports"
#define PATH_RMTAB      "/usr/alexsrvr/etc/rmtab"

/* File containing special passwords for hosts that don't just accept
 * the user name as password for anonymous ftpl login.
 */
#define ANON_PASSWD	"/usr/alexsrvr/etc/passwd"

/* If a Unix file is unreadable don't list it.  Alex does not correctly 
* show protections and this is a temporary hack so that a "find" can 
* be done.  If you are not doing any finds you may not want this.     */ 
#define ONLYSHOWREADABLE 

/* Like the above, defining the following increases Alex's odds of 
*  working for a find or database build at the expense of a few files */
#define ONLYSAFEPARSE 

/* So Alex can mail Vince a little bit of data to help Vince graduate */ 
#define MAILPERFSTATS  

/* If Alex is supposed to send mail but can not find an smtp server and 
 * the following is defined will exec that mail program */
#define UCBMAILPATH "/usr/ucb/mail"

/* If you would rather not send mail, comment out MAILPERFSTATS and set the 
 * path below so that Alex can put a small amount of performance info in a 
 * place where I can FTP it (with Alex) and then send me email with the Alex 
 * path I should use to get the data.  Thanks  vac@cs.cmu.edu                */

#define FTPABLEPERFLOG "/usr/anon/alexperf.log"


/* I think the following is dangerous (and did not implement it myself).
 * Defining this means that executables will show up as executable.
 * The danger is that their is a "ls" script that is a virus and someone
 * has "." on their path. */

/* #define EXECUTABLE */
