/* Copyright (c) 1992 Vincent Cate
 * All Rights Reserved.
 *
 * Permission to use and modify this software and its documentation
 * is hereby granted, provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative works
 * or modified versions, and any portions thereof, and that both notices
 * appear in supporting documentation.  This software or any derivate works
 * may not be sold or distributed without prior written approval from
 * Vincent Cate.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND VINCENT CATE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * VINCENT CATE BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Users of this software agree to return to Vincent Cate any improvements
 * or extensions that they make and grant Vincent Cate the rights to
 * redistribute these changes.
 *
 *
 * This file completely rewritten by
 *
 *           Juergen Hannken-Illjes (hannken@eis.cs.tu-bs.de)
 *
 * 
 * Exports:
 * 
 * extern int
 * InTransit(char *pathName);
 *  return:
 *    TRUE:  if transfer of file is in progress
 *    FALSE: otherwise
 *
 * 
 * extern int NumFinishedFTPs
 *  Number of succesful FTPs done so far
 *
 *
 * extern int
 * DoAnFtp(struct HostEntry *hostPtr, char *command, char *remPath,
 *         char *resultPath);
 *  return:
 *    AOK:       if file or directory has been transferred successfully
 *    AOLD:      if file doesn't exist on remote host (any more)
 *                 this doesn't work for directorys, as the error is written
 *                 to the output file as '... not found'
 *    AFAILED:   if transfer failed and will likely fail, if command is redone
 *    AWORKING:  if transfer is in progress
 *    SOFTERROR: if there is no free slot (MAXFTPSOPEN reached)
 * 
 *  side effect:
 *    uses and updates the following fields of *hostPtr:
 *      Path:       used to create hostname
 *      Type:       used to determine host type, set, if type changes
 *      HowWorking: used and set to collect recent failures
 *      LastUsed:   used and set
 * 
 *    updates NumFinishedFTPs
 * 
 * 
 * Imports:
 *
 * SetLogBaseName()
 * debugLog 
 * Log()
 * ATypeToString()
 *
 * PathToHostName()
 * TimeInSeconds()
 *
 *
 * Whenever you access a file in alex-cache, do it as follows:
 *
 *   if(ExistsInCacheAndSizeOk(pathname)) || 
 *           (InTransit(pathname) && BigEnough(pathname, NeededSize)) {
 *             use the file
 *    } else {
 *
 *         result = DoAnFtp(...);
 *         if(result == AOK)
 *           update stat info, proceed;
 *         if(result == AFAILED || result == AOLD)
 *           update stat info, return(AFAIL);
 *         if(result == SOFTERROR)
 *           return(AWORKING); (* try again next time *)
 *         if(result == AWORKING){
 *           if(SizeOk(pathname))
 *             proceed;
 *           else
 *             return(AWORKING);
 *       }
 *   }
 *   proceed as normal
 * 
 */



#define MAXCOMMAND	(MAXPATH*2+4)	/* two paths, command and '\0' */

extern char passWord[MAXPATH];		/* anon password: "user@host" */


/* FTP child code: the following code will be used after a fork() */

/*
 * Messages from or to FTP process. All messages are terminated by a newline.
 * FTP_CONNECTED is followed by SYSTYPE and ROOTDIRECTORY as in:
 *   'cu /usr/anon'
 * FTP_GET and FTP_DIR are followed by REMOTENAME and LOCALNAME as:
 *  'g /usr/anon/readme /alexhome/alex-cache/readme'
 * All messages other than FTP_OK may be followed by a string describing
 * the problem.
 */

#define FTP_CONNECTED	'c'		/* from ftp process and status */
#define FTP_OK		'o'		/* from ftp process and status */
#define FTP_NOANON	'n'		/* from ftp process and status */
#define FTP_NOTTHERE	'x'		/* from ftp process and status */
#define FTP_FAILED	'f'		/* from ftp process and status */
#define FTP_RETRY	'r'		/* from ftp process and status */
#define FTP_EXITED	'e'		/* from ftp process and status */
#define FTP_NOSUCHHOST  'h'             /* from ftp gethostbyname says it will never work */
#define FTP_GET		'g'		/* to ftp process only */
#define FTP_DIR		'd'		/* to ftp process only */
#define FTP_QUIT	'q'		/* to ftp process only */
#define FTP_IDLE	'i'		/* status only */
#define FTP_WORKING	'w'		/* status only */

#define FTP_RUNNING(s)	((s) == FTP_WORKING || (s) == FTP_OK || \
		(s) == FTP_IDLE)	/* true, if ftp should be running */

#define SYS_UNIX	'u'		/* system type is UNIX */
#define SYS_VMS		'v'		/* system type is VMS */
#define SYS_UNKNOWN	'?'		/* system type is something eles */

#define CLIENTTIMEOUT	120		/* Client exits after this time */
#define QUITTIMEOUT	30		/* - " - for QUIT command */
#define IDLETIMEOUT	300		/* Client exits after this time idle */

extern void StartFtpClient();

