/* tndfa.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-04-05 Reorganize library */

#include <stdlib.h>
#include <arpa/telnet.h>
#include "firewall.h"
#include "libemtn.h"
#include "tnint.h"


void tn_reset_dfa (tnconn *t)
{
  t->dfa = DFA_INIT;
}


tndfa tn_dfa (tnconn *t, int c)
{
  switch (t->dfa)
    {
    case DFA_INIT:
      if (c == IAC)
	{
	  t->dfa = DFA_IAC;
	  return TN_MORE;
	}
      else
	return TN_CHAR;
    case DFA_IAC:
      if (c == IAC)
	{
	  t->dfa = DFA_INIT;
	  return TN_CHAR;
	}
      else if (c == DO || c == DONT || c == WILL || c == WONT)
	{
	  t->dfa = DFA_NEGOTIATE;
	  return TN_MORE;
	}
      t->dfa = DFA_INIT;
      if (c == IP)
	return TN_IP;
      else
	return TN_IGNORE;
    case DFA_NEGOTIATE:
      return TN_IGNORE;
    default:
      t->dfa = DFA_INIT;
      return TN_IGNORE;
    }
}
